/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.crypto.paddings;

import io.soft.algorithm.crypto.paddings.BlockCipherPadding;
import io.soft.algorithm.exception.AlgorithmCallingException;
import java.security.SecureRandom;

public class PKCS7Padding
implements BlockCipherPadding {
    public void init(SecureRandom random) throws IllegalArgumentException {
    }

    public String getPaddingName() {
        return "PKCS7";
    }

    public int addPadding(byte[] in, int inOff) {
        byte code = (byte)(in.length - inOff);
        while (inOff < in.length) {
            in[inOff] = code;
            ++inOff;
        }
        return code;
    }

    public int padCount(byte[] in) throws AlgorithmCallingException {
        int count = in[in.length - 1] & 0xFF;
        byte countAsbyte = (byte)count;
        boolean failed = count > in.length | count == 0;
        for (int i = 0; i < in.length; ++i) {
            failed |= in.length - i <= count & in[i] != countAsbyte;
        }
        if (failed) {
            throw new AlgorithmCallingException("pad block corrupted");
        }
        return count;
    }
}

