/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.crypto.paddings;

import io.soft.algorithm.crypto.paddings.BlockCipherPadding;
import io.soft.algorithm.exception.AlgorithmCallingException;
import java.security.SecureRandom;

public class ISO7816d4Padding
implements BlockCipherPadding {
    public void init(SecureRandom random) throws IllegalArgumentException {
    }

    public String getPaddingName() {
        return "ISO7816-4";
    }

    public int addPadding(byte[] in, int inOff) {
        int added = in.length - inOff;
        in[inOff] = -128;
        ++inOff;
        while (inOff < in.length) {
            in[inOff] = 0;
            ++inOff;
        }
        return added;
    }

    public int padCount(byte[] in) throws AlgorithmCallingException {
        int count;
        for (count = in.length - 1; count > 0 && in[count] == 0; --count) {
        }
        if (in[count] != -128) {
            throw new AlgorithmCallingException("pad block corrupted");
        }
        return in.length - count;
    }
}

