/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.crypto.paddings;

import io.soft.algorithm.crypto.CryptoServicesRegistrar;
import io.soft.algorithm.crypto.paddings.BlockCipherPadding;
import io.soft.algorithm.exception.AlgorithmCallingException;
import java.security.SecureRandom;

public class ISO10126d2Padding
implements BlockCipherPadding {
    SecureRandom random;

    public void init(SecureRandom random) throws IllegalArgumentException {
        this.random = random != null ? random : CryptoServicesRegistrar.getSecureRandom();
    }

    public String getPaddingName() {
        return "ISO10126-2";
    }

    public int addPadding(byte[] in, int inOff) {
        byte code = (byte)(in.length - inOff);
        while (inOff < in.length - 1) {
            in[inOff] = (byte)this.random.nextInt();
            ++inOff;
        }
        in[inOff] = code;
        return code;
    }

    public int padCount(byte[] in) throws AlgorithmCallingException {
        int count = in[in.length - 1] & 0xFF;
        if (count > in.length) {
            throw new AlgorithmCallingException("pad block corrupted");
        }
        return count;
    }
}

