/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.crypto.modes;

import io.soft.algorithm.crypto.modes.gcm.GCMExponentiator;
import io.soft.algorithm.crypto.modes.gcm.GCMUtil;
import io.soft.algorithm.util.Arrays;

public class BasicGCMExponentiator
implements GCMExponentiator {
    private long[] x;

    public void init(byte[] x) {
        this.x = GCMUtil.asLongs(x);
    }

    public void exponentiateX(long pow, byte[] output) {
        long[] y = GCMUtil.oneAsLongs();
        if (pow > 0L) {
            long[] powX = Arrays.clone(this.x);
            do {
                if ((pow & 1L) != 0L) {
                    GCMUtil.multiply(y, powX);
                }
                GCMUtil.square(powX, powX);
            } while ((pow >>>= 1) > 0L);
        }
        GCMUtil.asBytes(y, output);
    }
}

