/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.crypto.asymmetric;

import io.soft.algorithm.util.UnionUtils;
import java.math.BigInteger;
import java.security.PrivateKey;

public class SM2PrivateKey
implements PrivateKey {
    private static final long serialVersionUID = -8642664675083754692L;
    private final String ALGORITHM = "SM2";
    private BigInteger d;

    public SM2PrivateKey() {
    }

    public SM2PrivateKey(BigInteger d) {
        this.d = d;
    }

    public String getAlgorithm() {
        return "SM2";
    }

    public byte[] getEncoded() {
        return this.padding(this.d.toByteArray(), 32);
    }

    public String getPvkHex() {
        return UnionUtils.bcdhex_to_aschex(this.getEncoded());
    }

    public String getFormat() {
        return this.getPvkHex();
    }

    public BigInteger getD() {
        return this.d;
    }

    public void setD(BigInteger d) {
        this.d = d;
    }

    public byte[] padding(byte[] key, int length) {
        if (key.length == length) {
            return key;
        }
        if (key.length > length) {
            byte[] dest = new byte[length];
            System.arraycopy(key, key.length - length, dest, 0, length);
            return dest;
        }
        byte[] dest = new byte[length];
        for (int i = 0; i < length - key.length; ++i) {
            dest[i] = 0;
        }
        System.arraycopy(key, 0, dest, length - key.length, key.length);
        return dest;
    }
}

