/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.crypto.asymmetric;

import io.soft.algorithm.asn1.ASN1Encodable;
import io.soft.algorithm.asn1.ASN1Integer;
import io.soft.algorithm.asn1.ASN1Primitive;
import io.soft.algorithm.asn1.ASN1Sequence;
import io.soft.algorithm.asn1.DERSequence;
import io.soft.algorithm.crypto.asymmetric.SM2PrivateKey;
import io.soft.algorithm.crypto.asymmetric.SM2PublicKey;
import io.soft.algorithm.crypto.digests.SM3Digest;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.math.ec.ECCurve;
import io.soft.algorithm.math.ec.ECPoint;
import io.soft.algorithm.util.BigIntegers;
import io.soft.algorithm.util.ByteUtils;
import io.soft.algorithm.util.Hex;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SM2Algorithm {
    public static final BigInteger p = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    public static final BigInteger a = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    public static final BigInteger b = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    public static final BigInteger n = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
    public static final BigInteger gx = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    public static final BigInteger gy = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    private static final ECCurve sm2Curve = new ECCurve.Fp(p, a, b);
    private static final ECPoint sm2Point = sm2Curve.createPoint(gx, gy);
    private static byte[] USER_ID = Hex.decode("31323334353637383132333435363738");
    private static int mFieldSizeInBytes;
    private static ECCurve curve256;
    private static ECPoint g256;

    public static byte[] encrypt(SM2PublicKey pbk, byte[] data) {
        String buf = Hex.encode(pbk.getEncoded());
        String pbX = buf.substring(0, 64);
        String pbY = buf.substring(64, 128);
        return SM2Algorithm.encrypt(pbX, pbY, data);
    }

    public static byte[] decrypt(SM2PrivateKey pvk, byte[] cipher) {
        String buf = Hex.encode(pvk.getEncoded());
        return SM2Algorithm.decrypt(buf, cipher);
    }

    public static byte[] encrypt(String pbkX, String pbkY, byte[] data) {
        byte[] t = null;
        ECPoint c1 = null;
        BigInteger x2 = null;
        BigInteger y2 = null;
        BigInteger x1 = new BigInteger(pbkX, 16);
        BigInteger y1 = new BigInteger(pbkY, 16);
        while (SM2Algorithm.isEmpty(t)) {
            ECPoint s;
            BigInteger k = SM2Algorithm.generateRand(32);
            c1 = SM2Algorithm.calculateC1(k);
            try {
                s = SM2Algorithm.calculateS(x1, y1, k);
            }
            catch (Exception e) {
                throw new AlgorithmCallingException("Failed to calculate S.");
            }
            x2 = SM2Algorithm.calculateX2(s);
            y2 = SM2Algorithm.calculateY2(s);
            if (x2.toByteArray().length < 32 || y2.toByteArray().length < 32) continue;
            t = SM2Algorithm.kdf(x2, y2, data.length);
        }
        byte[] c2 = SM2Algorithm.calculateC2(data, t);
        byte[] c3 = SM2Algorithm.calculateC3(x2, data, y2);
        return SM2Algorithm.getC(c1, c3, c2);
    }

    public static byte[] decrypt(String pvk, byte[] data) {
        BigInteger y2;
        String hexCipher = Hex.encode(data);
        String pbX = hexCipher.substring(0, 64);
        String pbY = hexCipher.substring(64, 128);
        byte[] c3 = Hex.decode(hexCipher.substring(128, 192));
        byte[] c2 = Hex.decode(hexCipher.substring(192, hexCipher.length()));
        ECPoint s = SM2Algorithm.calculateS(new BigInteger(pbX, 16), new BigInteger(pbY, 16), new BigInteger(pvk, 16));
        BigInteger x2 = s.getX().toBigInteger();
        byte[] t = SM2Algorithm.kdf(x2, y2 = s.getY().toBigInteger(), c2.length);
        if (SM2Algorithm.isEmpty(t)) {
            return null;
        }
        byte[] m = SM2Algorithm.calculateC2(t, c2);
        byte[] cc3 = SM2Algorithm.calculateC3(x2, m, y2);
        boolean sign = true;
        for (int i = 0; i < c3.length; ++i) {
            if (c3.length != cc3.length) {
                sign = false;
                break;
            }
            if (c3[i] == cc3[i]) continue;
            sign = false;
            break;
        }
        if (sign) {
            return m;
        }
        throw new AlgorithmCallingException("Failed to decrypt data using SM2 private key.");
    }

    private static BigInteger generateRand(int length) {
        BigInteger k = BigInteger.ZERO;
        SecureRandom secureRandom = new SecureRandom();
        byte[] buf = new byte[length];
        while (k.compareTo(BigInteger.ZERO) <= 0 || k.compareTo(n) >= 0) {
            secureRandom.nextBytes(buf);
            k = new BigInteger(1, buf);
        }
        return k;
    }

    private static ECPoint calculateC1(BigInteger k) {
        return sm2Point.multiply(k);
    }

    private static ECPoint calculateS(BigInteger x1, BigInteger y1, BigInteger k) {
        return sm2Curve.createPoint(x1, y1).multiply(k);
    }

    private static BigInteger calculateX2(ECPoint s) {
        return s.getX().toBigInteger();
    }

    private static BigInteger calculateY2(ECPoint s) {
        return s.getY().toBigInteger();
    }

    private static byte[] kdf(BigInteger x2, BigInteger y2, int keyLen) {
        byte[] t = new byte[keyLen];
        SM3Digest sm3 = new SM3Digest();
        byte[] sm3Ret = new byte[32];
        int ct = 1;
        int value = keyLen / 32;
        int remainder = keyLen % 32;
        byte[] x2Buf = SM2Algorithm.padding(x2.toByteArray());
        byte[] y2Buf = SM2Algorithm.padding(y2.toByteArray());
        int offset = 0;
        for (int i = 0; i < value; ++i) {
            sm3.update(x2Buf, 0, x2Buf.length);
            sm3.update(y2Buf, 0, y2Buf.length);
            sm3.update((byte)(ct >> 24 & 0xFF));
            sm3.update((byte)(ct >> 16 & 0xFF));
            sm3.update((byte)(ct >> 8 & 0xFF));
            sm3.update((byte)(ct & 0xFF));
            sm3.doFinal(t, offset);
            offset += 32;
            ++ct;
        }
        if (remainder != 0) {
            sm3.update(x2Buf, 0, x2Buf.length);
            sm3.update(y2Buf, 0, y2Buf.length);
            sm3.update((byte)(ct >> 24 & 0xFF));
            sm3.update((byte)(ct >> 16 & 0xFF));
            sm3.update((byte)(ct >> 8 & 0xFF));
            sm3.update((byte)(ct & 0xFF));
            sm3.doFinal(sm3Ret, 0);
        }
        System.arraycopy(sm3Ret, 0, t, offset, remainder);
        return t;
    }

    private static byte[] calculateC2(byte[] m, byte[] t) {
        if (m == null || m.length != t.length) {
            return null;
        }
        byte[] bufOut = new byte[m.length];
        for (int i = 0; i < m.length; ++i) {
            bufOut[i] = (byte)(m[i] ^ t[i]);
        }
        return bufOut;
    }

    private static byte[] calculateC3(BigInteger x2, byte[] m, BigInteger y2) {
        if (m == null) {
            return null;
        }
        SM3Digest sm3 = new SM3Digest();
        byte[] c3 = new byte[32];
        byte[] x2Buf = SM2Algorithm.padding(x2.toByteArray());
        byte[] y2Buf = SM2Algorithm.padding(y2.toByteArray());
        sm3.update(x2Buf, 0, x2Buf.length);
        sm3.update(m, 0, m.length);
        sm3.update(y2Buf, 0, y2Buf.length);
        sm3.doFinal(c3, 0);
        return c3;
    }

    private static byte[] getC(ECPoint c1, byte[] c3, byte[] c2) {
        byte[] c = new byte[64 + c3.length + c2.length];
        byte[] c1xBuf = SM2Algorithm.padding(c1.getX().toBigInteger().toByteArray());
        byte[] c1yBuf = SM2Algorithm.padding(c1.getY().toBigInteger().toByteArray());
        System.arraycopy(c1xBuf, 0, c, 0, 32);
        System.arraycopy(c1yBuf, 0, c, 32, 32);
        System.arraycopy(c3, 0, c, 64, c3.length);
        System.arraycopy(c2, 0, c, 64 + c3.length, c2.length);
        return c;
    }

    private static boolean isEmpty(byte[] t) {
        if (t != null) {
            for (byte i : t) {
                if (i == 0) continue;
                return false;
            }
        }
        return true;
    }

    private static byte[] padding(byte[] bi) {
        if (bi.length == 32) {
            return bi;
        }
        if (bi.length > 32) {
            byte[] dest = new byte[32];
            System.arraycopy(bi, bi.length - 32, dest, 0, 32);
            return dest;
        }
        byte[] dest = new byte[32];
        for (int i = 0; i < 32 - bi.length; ++i) {
            dest[i] = 0;
        }
        System.arraycopy(bi, 0, dest, 32 - bi.length, bi.length);
        return dest;
    }

    private static BigInteger[] Sign(byte[] md, BigInteger privateKeyS) {
        SM3Digest sm3 = new SM3Digest();
        byte[] z = SM2Algorithm.sm2GetZ(USER_ID, g256.multiply(privateKeyS));
        sm3.update(z, 0, z.length);
        sm3.update(md, 0, md.length);
        byte[] hashData = new byte[32];
        sm3.doFinal(hashData, 0);
        return SM2Algorithm.SignSm3(hashData, privateKeyS);
    }

    private static BigInteger[] SignSm3(byte[] hash, BigInteger privateKeyS) {
        BigInteger s;
        BigInteger r;
        byte[] hashData = ByteUtils.copyBytes(hash);
        BigInteger e = new BigInteger(1, hashData);
        while (true) {
            BigInteger k = SM2Algorithm.createRandom();
            ECPoint kp = g256.multiply(k);
            r = e.add(kp.getX().toBigInteger());
            if ((r = r.mod(n)).equals(BigInteger.ZERO) || r.add(k).equals(n)) continue;
            BigInteger da_1 = privateKeyS.add(BigInteger.ONE).modInverse(n);
            s = r.multiply(privateKeyS);
            s = k.subtract(s);
            s = s.multiply(da_1);
            if (!(s = s.mod(n)).equals(BigInteger.ZERO)) break;
        }
        BigInteger[] retRS = new BigInteger[]{r, s};
        return retRS;
    }

    private static boolean verify(byte[] msg, byte[] signData, BigInteger biX, BigInteger biY) {
        ECPoint userKey = curve256.createPoint(biX, biY);
        byte[] btR = ByteUtils.subByteArray(signData, 0, signData.length / 2);
        byte[] btS = ByteUtils.subByteArray(signData, btR.length, signData.length - btR.length);
        BigInteger r = new BigInteger(1, btR);
        if (!SM2Algorithm.checkValidateK(r)) {
            return false;
        }
        BigInteger s = new BigInteger(1, btS);
        if (!SM2Algorithm.checkValidateK(s)) {
            return false;
        }
        SM3Digest sm3 = new SM3Digest();
        byte[] z = SM2Algorithm.sm2GetZ(USER_ID, userKey);
        sm3.update(z, 0, z.length);
        sm3.update(msg, 0, msg.length);
        byte[] hashData = new byte[32];
        sm3.doFinal(hashData, 0);
        BigInteger e = new BigInteger(1, hashData);
        BigInteger t = r.add(s).mod(n);
        if (t.equals(BigInteger.ZERO)) {
            return false;
        }
        ECPoint x1y1 = g256.multiply(s);
        x1y1 = x1y1.add(userKey.multiply(t));
        BigInteger R = e.add(x1y1.getX().toBigInteger()).mod(n);
        return r.equals(R);
    }

    private static BigInteger createRandom() {
        BigInteger k;
        SecureRandom random = new SecureRandom();
        byte[] r = new byte[32];
        do {
            random.nextBytes(r);
        } while (!SM2Algorithm.checkValidateK(k = new BigInteger(1, r)));
        return k;
    }

    private static boolean checkValidateK(BigInteger k) {
        return k.compareTo(new BigInteger("0")) > 0 && k.compareTo(n) < 0;
    }

    private static byte[] sm2GetZ(byte[] userId, ECPoint publicKey) {
        SM3Digest sm3 = new SM3Digest();
        int BitsLength = userId.length << 3;
        sm3.update((byte)(BitsLength >> 8 & 0xFF));
        sm3.update((byte)(BitsLength & 0xFF));
        SM2Algorithm.sm3BlockUpdate(sm3, userId);
        SM2Algorithm.sm3BlockUpdate(sm3, SM2Algorithm.getEncoded(a));
        SM2Algorithm.sm3BlockUpdate(sm3, SM2Algorithm.getEncoded(b));
        SM2Algorithm.sm3BlockUpdate(sm3, SM2Algorithm.getEncoded(gx));
        SM2Algorithm.sm3BlockUpdate(sm3, SM2Algorithm.getEncoded(gy));
        SM2Algorithm.sm3BlockUpdate(sm3, SM2Algorithm.getEncoded(publicKey.getX().toBigInteger()));
        SM2Algorithm.sm3BlockUpdate(sm3, SM2Algorithm.getEncoded(publicKey.getY().toBigInteger()));
        byte[] md = new byte[sm3.getDigestSize()];
        sm3.doFinal(md, 0);
        return md;
    }

    private static void sm3BlockUpdate(SM3Digest sm3, byte[] bytes) {
        sm3.update(bytes, 0, bytes.length);
    }

    private static byte[] getEncoded(BigInteger value) {
        byte[] bytes = BigIntegers.asUnsignedByteArray(value);
        if (bytes.length > mFieldSizeInBytes) {
            byte[] tmp = new byte[mFieldSizeInBytes];
            System.arraycopy(bytes, bytes.length - mFieldSizeInBytes, tmp, 0, mFieldSizeInBytes);
            return tmp;
        }
        if (bytes.length < mFieldSizeInBytes) {
            byte[] tmp = new byte[mFieldSizeInBytes];
            System.arraycopy(bytes, 0, tmp, mFieldSizeInBytes - bytes.length, bytes.length);
            return tmp;
        }
        return bytes;
    }

    public static byte[] sign(byte[] data, SM2PrivateKey pvk) throws IOException {
        return SM2Algorithm.sign(data, pvk.getPvkHex());
    }

    public static byte[] sign(byte[] data, String hexPvk) throws IOException {
        BigInteger privateKeyS = new BigInteger(hexPvk, 16);
        BigInteger[] rs = SM2Algorithm.Sign(data, privateKeyS);
        ASN1Encodable[] ars = new ASN1Integer[]{new ASN1Integer(rs[0]), new ASN1Integer(rs[1])};
        return new DERSequence(ars).getEncoded("DER");
    }

    public static boolean verify(byte[] data, byte[] signData, SM2PublicKey pbk) throws IOException {
        return SM2Algorithm.verify(data, signData, pbk.getPbkxHex(), pbk.getPbkyHex());
    }

    public static boolean verify(byte[] data, byte[] signData, String hexPbkX, String hexPbkY) throws IOException {
        BigInteger biX = new BigInteger(hexPbkX, 16);
        BigInteger biY = new BigInteger(hexPbkY, 16);
        ASN1Sequence as = (ASN1Sequence)ASN1Primitive.fromByteArray(signData);
        BigInteger[] rs = new BigInteger[]{((ASN1Integer)as.getObjectAt(0)).getValue(), ((ASN1Integer)as.getObjectAt(1)).getValue()};
        byte[] r = SM2Algorithm.getEncoded(rs[0]);
        byte[] s = SM2Algorithm.getEncoded(rs[1]);
        byte[] rsBytes = new byte[r.length + s.length];
        System.arraycopy(r, 0, rsBytes, 0, r.length);
        System.arraycopy(s, 0, rsBytes, r.length, s.length);
        return SM2Algorithm.verify(data, rsBytes, biX, biY);
    }

    public static byte[] simpleSignWithSM3(byte[] data, String hexPvk, byte[] user_id) {
        BigInteger privateKeyS = new BigInteger(hexPvk, 16);
        if (user_id == null) {
            user_id = USER_ID;
        }
        SM3Digest sm3 = new SM3Digest();
        byte[] z = SM2Algorithm.sm2GetZ(user_id, g256.multiply(privateKeyS));
        sm3.update(z, 0, z.length);
        sm3.update(data, 0, data.length);
        byte[] hashData = new byte[32];
        sm3.doFinal(hashData, 0);
        BigInteger[] rs = SM2Algorithm.SignSm3(hashData, privateKeyS);
        byte[] r = SM2Algorithm.getEncoded(rs[0]);
        byte[] s = SM2Algorithm.getEncoded(rs[1]);
        byte[] sign = new byte[r.length + s.length];
        System.arraycopy(r, 0, sign, 0, r.length);
        System.arraycopy(s, 0, sign, r.length, s.length);
        return sign;
    }

    public static boolean simpleVerifyWithSM3(byte[] data, byte[] signData, String hexPbkX, String hexPbkY, byte[] user_id) {
        if (user_id == null) {
            user_id = USER_ID;
        }
        BigInteger biX = new BigInteger(hexPbkX, 16);
        BigInteger biY = new BigInteger(hexPbkY, 16);
        String signDataHex = Hex.encode(signData);
        int signLen = signDataHex.length();
        byte[] btR = Hex.decode(signDataHex.substring(0, signData.length));
        byte[] btS = Hex.decode(signDataHex.substring(signData.length, signLen));
        ECPoint userKey = curve256.createPoint(biX, biY);
        BigInteger r = new BigInteger(1, btR);
        if (!SM2Algorithm.checkValidateK(r)) {
            return false;
        }
        BigInteger s = new BigInteger(1, btS);
        if (!SM2Algorithm.checkValidateK(s)) {
            return false;
        }
        SM3Digest sm3 = new SM3Digest();
        byte[] z = SM2Algorithm.sm2GetZ(user_id, userKey);
        sm3.update(z, 0, z.length);
        sm3.update(data, 0, data.length);
        byte[] hashData = new byte[32];
        sm3.doFinal(hashData, 0);
        BigInteger e = new BigInteger(1, hashData);
        BigInteger t = r.add(s).mod(n);
        if (t.equals(BigInteger.ZERO)) {
            return false;
        }
        ECPoint x1y1 = g256.multiply(s);
        x1y1 = x1y1.add(userKey.multiply(t));
        BigInteger R = e.add(x1y1.getX().toBigInteger()).mod(n);
        return r.equals(R);
    }

    static {
        curve256 = new ECCurve.Fp(p, a, b);
        g256 = curve256.createPoint(gx, gy);
        mFieldSizeInBytes = p.bitLength() + 7 >> 3;
    }
}

