/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.crypto.agreement;

import io.soft.algorithm.crypto.CipherParameters;
import io.soft.algorithm.crypto.agreement.BasicAgreement;
import io.soft.algorithm.crypto.params.ECDomainParameters;
import io.soft.algorithm.crypto.params.ECPrivateKeyParameters;
import io.soft.algorithm.crypto.params.ECPublicKeyParameters;
import io.soft.algorithm.math.ec.ECAlgorithms;
import io.soft.algorithm.math.ec.ECPoint;
import java.math.BigInteger;

public class ECDHCBasicAgreement
implements BasicAgreement {
    ECPrivateKeyParameters key;

    public void init(CipherParameters key) {
        this.key = (ECPrivateKeyParameters)key;
    }

    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters pubKey) {
        ECPublicKeyParameters pub = (ECPublicKeyParameters)pubKey;
        ECDomainParameters params = this.key.getParameters();
        if (!params.equals(pub.getParameters())) {
            throw new IllegalStateException("ECDHC public key has wrong domain parameters");
        }
        BigInteger hd = params.getH().multiply(this.key.getD()).mod(params.getN());
        ECPoint pubPoint = ECAlgorithms.cleanPoint(params.getCurve(), pub.getQ());
        if (pubPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid public key for ECDHC");
        }
        ECPoint P = pubPoint.multiply(hd).normalize();
        if (P.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECDHC");
        }
        return P.getAffineXCoord().toBigInteger();
    }
}

