/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.asn1;

import io.soft.algorithm.asn1.ASN1EncodableVector;
import io.soft.algorithm.asn1.ASN1Object;
import io.soft.algorithm.asn1.ASN1OctetString;
import io.soft.algorithm.asn1.ASN1Primitive;
import io.soft.algorithm.asn1.ASN1Sequence;
import io.soft.algorithm.asn1.ASN1TaggedObject;
import io.soft.algorithm.asn1.AlgorithmIdentifier;
import io.soft.algorithm.asn1.DEROctetString;
import io.soft.algorithm.asn1.DERSequence;
import io.soft.algorithm.util.Arrays;
import java.util.Enumeration;

public class DigestInfo
extends ASN1Object {
    private byte[] digest;
    private AlgorithmIdentifier algId;

    public static DigestInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DigestInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static DigestInfo getInstance(Object obj) {
        if (obj instanceof DigestInfo) {
            return (DigestInfo)obj;
        }
        if (obj != null) {
            return new DigestInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public DigestInfo(AlgorithmIdentifier algId, byte[] digest) {
        this.digest = Arrays.clone(digest);
        this.algId = algId;
    }

    public DigestInfo(ASN1Sequence obj) {
        Enumeration e = obj.getObjects();
        this.algId = AlgorithmIdentifier.getInstance(e.nextElement());
        this.digest = ASN1OctetString.getInstance(e.nextElement()).getOctets();
    }

    public AlgorithmIdentifier getAlgorithmId() {
        return this.algId;
    }

    public byte[] getDigest() {
        return Arrays.clone(this.digest);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.algId);
        v.add(new DEROctetString(this.digest));
        return new DERSequence(v);
    }
}

