/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.asn1;

import io.soft.algorithm.asn1.ASN1Encodable;
import io.soft.algorithm.asn1.ASN1OutputStream;
import io.soft.algorithm.asn1.ASN1Primitive;
import io.soft.algorithm.asn1.ASN1TaggedObject;
import io.soft.algorithm.asn1.StreamUtil;
import java.io.IOException;

public class DERTaggedObject
extends ASN1TaggedObject {
    private static final byte[] ZERO_BYTES = new byte[0];

    public DERTaggedObject(boolean explicit, int tagNo, ASN1Encodable obj) {
        super(explicit, tagNo, obj);
    }

    public DERTaggedObject(int tagNo, ASN1Encodable encodable) {
        super(true, tagNo, encodable);
    }

    boolean isConstructed() {
        if (!this.empty) {
            if (this.explicit) {
                return true;
            }
            ASN1Primitive primitive = this.obj.toASN1Primitive().toDERObject();
            return primitive.isConstructed();
        }
        return true;
    }

    int encodedLength() throws IOException {
        if (!this.empty) {
            ASN1Primitive primitive = this.obj.toASN1Primitive().toDERObject();
            int length = primitive.encodedLength();
            if (this.explicit) {
                return StreamUtil.calculateTagLength(this.tagNo) + StreamUtil.calculateBodyLength(length) + length;
            }
            return StreamUtil.calculateTagLength(this.tagNo) + --length;
        }
        return StreamUtil.calculateTagLength(this.tagNo) + 1;
    }

    void encode(ASN1OutputStream out) throws IOException {
        if (!this.empty) {
            ASN1Primitive primitive = this.obj.toASN1Primitive().toDERObject();
            if (this.explicit) {
                out.writeTag(160, this.tagNo);
                out.writeLength(primitive.encodedLength());
                out.writeObject(primitive);
            } else {
                int flags = primitive.isConstructed() ? 160 : 128;
                out.writeTag(flags, this.tagNo);
                out.writeImplicitObject(primitive);
            }
        } else {
            out.writeEncoded(160, this.tagNo, ZERO_BYTES);
        }
    }
}

