/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.asn1;

import io.soft.algorithm.asn1.ASN1OctetString;
import io.soft.algorithm.asn1.ASN1OutputStream;
import io.soft.algorithm.asn1.ASN1Primitive;
import io.soft.algorithm.asn1.ASN1String;
import io.soft.algorithm.asn1.ASN1TaggedObject;
import io.soft.algorithm.asn1.DERT61String;
import io.soft.algorithm.asn1.StreamUtil;
import io.soft.algorithm.util.Arrays;
import io.soft.algorithm.util.Strings;
import java.io.IOException;

public class DERT61UTF8String
extends ASN1Primitive
implements ASN1String {
    private byte[] string;

    public static DERT61UTF8String getInstance(Object obj) {
        if (obj instanceof DERT61String) {
            return new DERT61UTF8String(((DERT61String)obj).getOctets());
        }
        if (obj == null || obj instanceof DERT61UTF8String) {
            return (DERT61UTF8String)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return new DERT61UTF8String(((DERT61String)DERT61UTF8String.fromByteArray((byte[])obj)).getOctets());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERT61UTF8String getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof DERT61String || o instanceof DERT61UTF8String) {
            return DERT61UTF8String.getInstance(o);
        }
        return new DERT61UTF8String(ASN1OctetString.getInstance(o).getOctets());
    }

    public DERT61UTF8String(byte[] string) {
        this.string = string;
    }

    public DERT61UTF8String(String string) {
        this(Strings.toUTF8ByteArray(string));
    }

    public String getString() {
        return Strings.fromUTF8ByteArray(this.string);
    }

    public String toString() {
        return this.getString();
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.string.length) + this.string.length;
    }

    void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(20, this.string);
    }

    public byte[] getOctets() {
        return Arrays.clone(this.string);
    }

    boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof DERT61UTF8String)) {
            return false;
        }
        return Arrays.areEqual(this.string, ((DERT61UTF8String)o).string);
    }

    public int hashCode() {
        return Arrays.hashCode(this.string);
    }
}

