/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api.v1;

import io.soft.algorithm.api.v1.Algorithm;
import io.soft.algorithm.api.v1.ECCSignature;
import io.soft.algorithm.api.v1.RSASignature;
import io.soft.algorithm.api.v1.SM2Signature;
import io.soft.algorithm.exception.AlgorithmCallingException;
import java.io.File;
import java.io.InputStream;

public class Signature {
    public static Signature getInstance(Algorithm signAlg, Algorithm hashAlg) {
        switch (signAlg) {
            case SM2: {
                if (hashAlg != Algorithm.NONE) {
                    throw new AlgorithmCallingException("SM2 signature does not support this hash:" + (Object)((Object)hashAlg));
                }
                return new SM2Signature();
            }
            case RSA: {
                return new RSASignature(hashAlg);
            }
            case ECC: {
                return new ECCSignature(hashAlg);
            }
        }
        throw new AlgorithmCallingException("Algorithm for signature is not supported.");
    }

    public Signature setCurve(String curve) {
        return null;
    }

    public Signature setUserID(byte[] userID) {
        return null;
    }

    public byte[] sign(byte[] privateKey, byte[] data) {
        return null;
    }

    public boolean verify(byte[] publicKey, byte[] data, byte[] sign) {
        return false;
    }

    public byte[] sign(byte[] privateKey, InputStream stream) {
        return null;
    }

    public boolean verify(byte[] publicKey, InputStream stream, byte[] sign) {
        return false;
    }

    public byte[] sign(byte[] privateKey, File file) {
        return null;
    }

    public boolean verify(byte[] publicKey, File file, byte[] sign) {
        return false;
    }
}

