/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api.v1;

import io.soft.algorithm.api.v1.Algorithm;
import io.soft.algorithm.api.v1.MessageDigest;
import io.soft.algorithm.api.v1.Signature;
import io.soft.algorithm.crypto.asymmetric.SM2Algorithm;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.util.Checker;
import io.soft.algorithm.util.Hex;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

class SM2Signature
extends Signature {
    private byte[] USER_ID = null;

    SM2Signature() {
    }

    public Signature setUserID(byte[] userID) {
        Checker.check(userID != null, "the userID for SM2 signature can not be set as null", new Object[0]);
        this.USER_ID = userID;
        return super.setUserID(userID);
    }

    public byte[] sign(byte[] privateKey, byte[] data) {
        Checker.check(privateKey != null, "the private key for sm2 sign can not be null.", new Object[0]);
        Checker.check(data != null, "the data  for sm2 sign can not be null.", new Object[0]);
        Checker.check(data.length != 0, "the length of sm2 sign data must be more than 0 byte.", new Object[0]);
        Checker.check(privateKey.length == 32, "the length of private key must be 32 bytes.", new Object[0]);
        String key = Hex.encode(privateKey);
        return SM2Algorithm.simpleSignWithSM3(data, key, this.USER_ID);
    }

    public boolean verify(byte[] publicKey, byte[] data, byte[] sign) {
        Checker.check(publicKey != null, "the public key of sm2 signature verify can not be null.", new Object[0]);
        Checker.check(sign != null, "the sign of sm2 signature verify can not be null.", new Object[0]);
        Checker.check(data != null, "Illegal Argument: The data of sm2 signature can not be null.", new Object[0]);
        Checker.check(data.length != 0, "Illegal Argument: The length of sm2 signature data must be more than 0 byte.", new Object[0]);
        Checker.check(publicKey.length == 64, "Illegal Argument: SM2 public key error, must be 64 bytes.", new Object[0]);
        Checker.check(sign.length == 64, "Illegal Argument: SM2 sign error, must be 64 bytes and in the format r||s.", new Object[0]);
        String key = Hex.encode(publicKey);
        return SM2Algorithm.simpleVerifyWithSM3(data, sign, key.substring(0, 64), key.substring(64, 128), this.USER_ID);
    }

    public byte[] sign(byte[] privateKey, InputStream stream) {
        MessageDigest messageDigest = MessageDigest.getInstance(Algorithm.SM3);
        byte[] hash = messageDigest.digest(stream);
        return this.sign(privateKey, hash);
    }

    public boolean verify(byte[] publicKey, InputStream stream, byte[] sign) {
        MessageDigest messageDigest = MessageDigest.getInstance(Algorithm.SM3);
        byte[] hash = messageDigest.digest(stream);
        return this.verify(publicKey, hash, sign);
    }

    public byte[] sign(byte[] privateKey, File file) {
        Checker.check(file.exists(), "Path: %s is not exists.", file);
        Checker.check(file.isFile(), "Not Found file.Excepted file,actual directory. Path: %s", file);
        Checker.check(file.canRead(), "Path: %s can not be read.", file);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            byte[] byArray = this.sign(privateKey, inputStream);
            return byArray;
        }
        catch (FileNotFoundException e) {
            Checker.check(!file.isFile() || !file.exists(), "Unauthorized access.", new Object[0]);
            throw new AlgorithmCallingException("Not Found file.", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean verify(byte[] publicKey, File file, byte[] sign) {
        Checker.check(file.exists(), "Path: %s is not exists.", file);
        Checker.check(file.isFile(), "Not Found file.Excepted file,actual directory. Path: %s", file);
        Checker.check(file.canRead(), "Path: %s can not be read.", file);
        FileInputStream in = null;
        try {
            boolean result;
            in = new FileInputStream(file);
            boolean bl = result = this.verify(publicKey, in, sign);
            return bl;
        }
        catch (FileNotFoundException e) {
            Checker.check(!file.exists() || !file.isFile(), "Unauthorized access.", new Object[0]);
            throw new AlgorithmCallingException("Not Found file.", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

