/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api.v1;

import io.soft.algorithm.api.v1.Cipher;
import io.soft.algorithm.crypto.asymmetric.SM2Algorithm;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.util.Checker;
import io.soft.algorithm.util.Hex;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

class SM2Cipher
extends Cipher {
    SM2Cipher() {
    }

    public Cipher setIv(byte[] iv) {
        throw new AlgorithmCallingException("Can not support set iv with SM2.");
    }

    public Cipher setAad(byte[] add) {
        throw new AlgorithmCallingException("Can not support set aad with SM2.");
    }

    public byte[] encrypt(byte[] key, byte[] data) {
        Checker.check(key != null, "Illegal Argument: SM2 public key can not be null.", new Object[0]);
        Checker.check(key.length == 64, "Illegal Argument: the size of SM2 public key must be 64 bytes.", new Object[0]);
        Checker.check(data != null, "Illegal Argument: the data length used for SM2 encryption can not be null.", new Object[0]);
        Checker.check(data.length != 0, "Illegal Argument: the data length used for encryption must be greater than zero byte.", new Object[0]);
        String sm2Key = Hex.encode(key);
        try {
            return SM2Algorithm.encrypt(sm2Key.substring(0, 64), sm2Key.substring(64, 128), data);
        }
        catch (AlgorithmCallingException e) {
            throw new AlgorithmCallingException("Failed to encrypt data using SM2 public key.");
        }
    }

    public byte[] decrypt(byte[] key, byte[] data) {
        Checker.check(key != null, "Illegal Argument: sm2 private key cannot be NULL.", new Object[0]);
        Checker.check(key.length == 32, "Illegal Argument: SM2 private key error, must be 32 bytes.", new Object[0]);
        Checker.check(data != null, "Illegal Argument: the data for sm2 decrypt  cannot be NULL.", new Object[0]);
        Checker.check(data.length >= 96, "Illegal Argument: the length of sm2 decrypt data must be more than 95 byte.", new Object[0]);
        try {
            return SM2Algorithm.decrypt(Hex.encode(key), data);
        }
        catch (Exception e) {
            throw new AlgorithmCallingException("Failed to decrypt data using SM2 private key.", e);
        }
    }

    public void encrypt(byte[] key, InputStream plainStream, OutputStream cipherStream) {
        throw new AlgorithmCallingException("SM2 cipher does not support streaming data.");
    }

    public void decrypt(byte[] key, InputStream cipherStream, OutputStream plainStream) {
        throw new AlgorithmCallingException("SM2 cipher does not support streaming data.");
    }

    public void encrypt(byte[] key, File plainFile, File cipherFile) {
        throw new AlgorithmCallingException("SM2 cipher does not support file data.");
    }

    public void decrypt(byte[] key, File cipherFile, File plainFile) {
        throw new AlgorithmCallingException("SM2 cipher does not support file data.");
    }
}

