/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api.v1;

import io.soft.algorithm.api.RSAPadding;
import io.soft.algorithm.api.v1.Algorithm;
import io.soft.algorithm.api.v1.AlgorithmHelper;
import io.soft.algorithm.api.v1.MessageDigest;
import io.soft.algorithm.api.v1.RSACipher;
import io.soft.algorithm.api.v1.Signature;
import io.soft.algorithm.crypto.Digest;
import io.soft.algorithm.crypto.digests.MD5Digest;
import io.soft.algorithm.crypto.digests.NullDigest;
import io.soft.algorithm.crypto.digests.SHA1Digest;
import io.soft.algorithm.crypto.digests.SHA224Digest;
import io.soft.algorithm.crypto.digests.SHA256Digest;
import io.soft.algorithm.crypto.digests.SHA384Digest;
import io.soft.algorithm.crypto.digests.SHA512Digest;
import io.soft.algorithm.crypto.params.RSAKeyParameters;
import io.soft.algorithm.crypto.params.RSAPrivateCrtKeyParameters;
import io.soft.algorithm.crypto.signers.RSADigestSigner;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.util.Arrays;
import io.soft.algorithm.util.Checker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.List;

class RSASignature
extends Signature {
    private Digest digest;
    private Algorithm alg;

    public RSASignature(Algorithm hash) {
        if (hash == null) {
            throw new AlgorithmCallingException("the algorithm for RSA signature can not be null.");
        }
        this.alg = hash;
        switch (hash) {
            case NONE: {
                this.digest = new NullDigest();
                break;
            }
            case SHA1: {
                this.digest = new SHA1Digest();
                break;
            }
            case SHA224: {
                this.digest = new SHA224Digest();
                break;
            }
            case SHA256: {
                this.digest = new SHA256Digest();
                break;
            }
            case SHA384: {
                this.digest = new SHA384Digest();
                break;
            }
            case SHA512: {
                this.digest = new SHA512Digest();
                break;
            }
            case MD5: {
                this.digest = new MD5Digest();
                break;
            }
            default: {
                throw new AlgorithmCallingException("RSA signature does not support this algorithm hash:" + (Object)((Object)hash));
            }
        }
    }

    public byte[] sign(byte[] privateKey, byte[] data) {
        RSAPrivateKey vk;
        Checker.check(data != null, "the data can not be null.", new Object[0]);
        Checker.check(data.length != 0, "the length of data must be more than 0 byte.", new Object[0]);
        Checker.check(privateKey != null, "private key must not be null.", new Object[0]);
        Checker.check(privateKey.length != 0, "the private key for RSA signature must be more than 0 byte.", new Object[0]);
        PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(privateKey);
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            vk = (RSAPrivateKey)factory.generatePrivate(encodedKeySpec);
        }
        catch (Exception e) {
            throw new AlgorithmCallingException("Invalid RSA private key", e);
        }
        RSAPrivateCrtKey rsaPrivateCrtKey = (RSAPrivateCrtKey)vk;
        BigInteger p = rsaPrivateCrtKey.getPrimeP();
        BigInteger q = rsaPrivateCrtKey.getPrimeQ();
        BigInteger dP = rsaPrivateCrtKey.getPrimeExponentP();
        BigInteger dQ = rsaPrivateCrtKey.getPrimeExponentQ();
        BigInteger qInv = rsaPrivateCrtKey.getCrtCoefficient();
        BigInteger privateKeyExponent = vk.getPrivateExponent();
        BigInteger publicKeyExponent = rsaPrivateCrtKey.getPublicExponent();
        BigInteger mod = rsaPrivateCrtKey.getModulus();
        RSAPrivateCrtKeyParameters privParameters = new RSAPrivateCrtKeyParameters(mod, publicKeyExponent, privateKeyExponent, p, q, dP, dQ, qInv);
        if (this.alg != Algorithm.NONE) {
            RSADigestSigner signer = new RSADigestSigner(this.digest);
            signer.init(true, privParameters);
            signer.update(data, 0, data.length);
            byte[] sig = signer.generateSignature();
            Checker.check(sig.length == mod.bitLength() / 8, "RSA sign failed.The length of sign is not consistent with key length.", new Object[0]);
            return sig;
        }
        return new RSACipher(RSAPadding.PKCS1Padding).encryptWithVK(privateKey, data, mod, privateKeyExponent);
    }

    public boolean verify(byte[] publicKey, byte[] data, byte[] sign) {
        Checker.check(sign != null, "the sign can not be null.", new Object[0]);
        Checker.check(sign.length != 0, "the length of sign must be more than 0 byte.", new Object[0]);
        Checker.check(data != null, "the data can not be null.", new Object[0]);
        Checker.check(data.length != 0, "the length of data must be more than 0 byte.", new Object[0]);
        Checker.check(publicKey != null, "public key must not be null.", new Object[0]);
        Checker.check(publicKey.length != 0, "the public key for RSA signature must be more than 0 byte.", new Object[0]);
        List<byte[]> info = AlgorithmHelper.parsePublicKey(publicKey);
        byte[] modules = info.get(0);
        byte[] exponent = info.get(1);
        BigInteger mod = new BigInteger(1, modules);
        BigInteger pubExp = new BigInteger(1, exponent);
        RSAKeyParameters pubParameters = new RSAKeyParameters(false, mod, pubExp);
        if (this.alg != Algorithm.NONE) {
            RSADigestSigner signer = new RSADigestSigner(this.digest);
            signer.init(false, pubParameters);
            signer.update(data, 0, data.length);
            return signer.verifySignature(sign);
        }
        byte[] res = new RSACipher(RSAPadding.PKCS1Padding).decryptWithPK(publicKey, sign, pubParameters);
        return Arrays.areEqual(res, data);
    }

    public byte[] sign(byte[] privateKey, InputStream stream) {
        Checker.check(this.alg != Algorithm.NONE, "RSA signature does not support digest streaming data when the algorithm is NONE.", new Object[0]);
        MessageDigest messageDigest = MessageDigest.getInstance(this.alg);
        byte[] hash = messageDigest.digest(stream);
        return this.sign(privateKey, hash);
    }

    public boolean verify(byte[] publicKey, InputStream stream, byte[] sign) {
        Checker.check(this.alg != Algorithm.NONE, "RSA signature does not support digest streaming data when the algorithm is NONE.", new Object[0]);
        MessageDigest messageDigest = MessageDigest.getInstance(this.alg);
        byte[] hash = messageDigest.digest(stream);
        return this.verify(publicKey, hash, sign);
    }

    public byte[] sign(byte[] privateKey, File file) {
        Checker.check(this.alg != Algorithm.NONE, "RSA signature does not support digest streaming data when the algorithm is NONE.", new Object[0]);
        Checker.check(file.exists(), "Path: %s is not exists.", file);
        Checker.check(file.isFile(), "Not Found file.Excepted file,actual directory. Path: %s", file);
        Checker.check(file.canRead(), "Path: %s can not be read.", file);
        FileInputStream in = null;
        try {
            byte[] result;
            in = new FileInputStream(file);
            byte[] byArray = result = this.sign(privateKey, in);
            return byArray;
        }
        catch (FileNotFoundException e) {
            Checker.check(!file.exists() || !file.isFile(), "Unauthorized access.", new Object[0]);
            throw new AlgorithmCallingException("Not Found file.", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean verify(byte[] publicKey, File file, byte[] sign) {
        Checker.check(this.alg != Algorithm.NONE, "RSA signature does not support digest streaming data when the algorithm is NONE.", new Object[0]);
        Checker.check(file.exists(), "Path: %s is not exists.", file);
        Checker.check(file.isFile(), "Not Found file.Excepted file,actual directory. Path: %s", file);
        Checker.check(file.canRead(), "Path: %s can not be read.", file);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            boolean bl = this.verify(publicKey, in, sign);
            return bl;
        }
        catch (FileNotFoundException e) {
            Checker.check(!file.isFile() || !file.exists(), "Unauthorized access.", new Object[0]);
            throw new AlgorithmCallingException("Not Found file.", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

