/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api.v1;

import io.soft.algorithm.api.RSAPadding;
import io.soft.algorithm.api.v1.AlgorithmHelper;
import io.soft.algorithm.api.v1.Cipher;
import io.soft.algorithm.crypto.AsymmetricBlockCipher;
import io.soft.algorithm.crypto.digests.SHA1Digest;
import io.soft.algorithm.crypto.digests.SHA256Digest;
import io.soft.algorithm.crypto.engines.RSAEngine;
import io.soft.algorithm.crypto.paddings.OAEPEncoding;
import io.soft.algorithm.crypto.paddings.PKCS1Encoding;
import io.soft.algorithm.crypto.params.ParametersWithRandom;
import io.soft.algorithm.crypto.params.RSAKeyParameters;
import io.soft.algorithm.crypto.params.RSAPrivateCrtKeyParameters;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.util.Checker;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.List;

class RSACipher
extends Cipher {
    private final AsymmetricBlockCipher eng;

    public RSACipher(RSAPadding padding) {
        switch (padding) {
            case NoPadding: {
                this.eng = new RSAEngine();
                break;
            }
            case PKCS1Padding: {
                this.eng = new PKCS1Encoding(new RSAEngine());
                break;
            }
            case OAEPWithMGFAndSHA256Padding: {
                this.eng = new OAEPEncoding(new RSAEngine(), new SHA256Digest(), new SHA1Digest(), new byte[10]);
                break;
            }
            default: {
                throw new AlgorithmCallingException("RSA cipher does not support this padding:" + padding);
            }
        }
    }

    public Cipher setIv(byte[] iv) {
        throw new AlgorithmCallingException("Can not support set iv with RSA.");
    }

    public Cipher setAad(byte[] add) {
        throw new AlgorithmCallingException("Can not support set aad with RSA.");
    }

    public byte[] encrypt(byte[] key, byte[] data) {
        byte[] cipherText;
        Checker.check(key != null, "Illegal Argument:  RSA public key cannot be NULL.", new Object[0]);
        Checker.check(data != null, "Illegal Argument: the data for RSA encrypt  cannot be NULL.", new Object[0]);
        Checker.check(data.length != 0, "Illegal Argument: the data for RSA encrypt must be more than 0 byte.", new Object[0]);
        List<byte[]> info = AlgorithmHelper.parsePublicKey(key);
        byte[] modulus = info.get(0);
        byte[] exponent = info.get(1);
        BigInteger mod = new BigInteger(1, modulus);
        BigInteger pubExp = new BigInteger(1, exponent);
        RSAKeyParameters pubParameters = new RSAKeyParameters(false, mod, pubExp);
        this.eng.init(true, new ParametersWithRandom(pubParameters, new SecureRandom()));
        try {
            cipherText = this.eng.processBlock(data, 0, data.length);
        }
        catch (AlgorithmCallingException e) {
            throw new AlgorithmCallingException(e);
        }
        return cipherText;
    }

    public byte[] encryptWithVK(byte[] key, byte[] data, BigInteger mod, BigInteger privateKeyExponent) {
        byte[] cipherText;
        Checker.check(key != null, "Illegal Argument 'key':  data cannot be NULL.", new Object[0]);
        Checker.check(data != null, "Illegal Argument 'data': the data cannot be NULL.", new Object[0]);
        Checker.check(data.length != 0, "Illegal Argument 'data': the data must be more than 0 byte.", new Object[0]);
        Checker.check(data.length <= (mod.bitLength() + 7) / 8 - 1 - 10, "Illegal Argument 'data':Long data must be signed using the digest interface.", new Object[0]);
        RSAKeyParameters priParameters = new RSAKeyParameters(true, mod, privateKeyExponent);
        this.eng.init(true, priParameters);
        try {
            cipherText = this.eng.processBlock(data, 0, data.length);
        }
        catch (AlgorithmCallingException e) {
            throw new AlgorithmCallingException(e);
        }
        return cipherText;
    }

    public byte[] decryptWithPK(byte[] key, byte[] sign, RSAKeyParameters pubParameters) {
        byte[] plaintext;
        Checker.check(key != null, "Illegal Argument 'sign':  RSA private key cannot be NULL.", new Object[0]);
        Checker.check(sign != null, "Illegal Argument 'sign': the signatures cannot be NULL.", new Object[0]);
        Checker.check(sign.length != 0, "Illegal Argument 'data': the signatures must be more than 0 byte.", new Object[0]);
        Checker.check(sign.length <= (pubParameters.getModulus().bitLength() + 7) / 8, "Illegal Argument 'sign':Long signatures must be verified using the digest interface.", new Object[0]);
        this.eng.init(false, pubParameters);
        try {
            plaintext = this.eng.processBlock(sign, 0, sign.length);
        }
        catch (AlgorithmCallingException e) {
            throw new AlgorithmCallingException("RSA decrypt failed.Caused by:", e);
        }
        return plaintext;
    }

    public byte[] decrypt(byte[] key, byte[] data) {
        byte[] plaintext;
        RSAPrivateKey vk;
        Checker.check(key != null, "Illegal Argument 'key':  RSA private key cannot be NULL.", new Object[0]);
        Checker.check(data != null, "Illegal Argument 'data': the data for RSA decrypt  cannot be NULL.", new Object[0]);
        Checker.check(data.length != 0, "Illegal Argument 'data': the data for RSA decrypt must be more than 0 byte.", new Object[0]);
        PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(key);
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            vk = (RSAPrivateKey)factory.generatePrivate(encodedKeySpec);
        }
        catch (Exception e) {
            throw new AlgorithmCallingException("Invalid RSA private key");
        }
        RSAPrivateCrtKey rsaPrivateCrtKey = (RSAPrivateCrtKey)vk;
        BigInteger p = rsaPrivateCrtKey.getPrimeP();
        BigInteger q = rsaPrivateCrtKey.getPrimeQ();
        BigInteger dP = rsaPrivateCrtKey.getPrimeExponentP();
        BigInteger dQ = rsaPrivateCrtKey.getPrimeExponentQ();
        BigInteger qInv = rsaPrivateCrtKey.getCrtCoefficient();
        BigInteger privateKeyExponent = vk.getPrivateExponent();
        BigInteger publicKeyExponent = rsaPrivateCrtKey.getPublicExponent();
        BigInteger mod = rsaPrivateCrtKey.getModulus();
        RSAPrivateCrtKeyParameters rsaPrivateCrtKeyParameters = new RSAPrivateCrtKeyParameters(mod, publicKeyExponent, privateKeyExponent, p, q, dP, dQ, qInv);
        this.eng.init(false, rsaPrivateCrtKeyParameters);
        try {
            plaintext = this.eng.processBlock(data, 0, data.length);
        }
        catch (AlgorithmCallingException e) {
            throw new AlgorithmCallingException("RSA decrypt failed.Caused by:", e);
        }
        return plaintext;
    }

    public void encrypt(byte[] key, InputStream plainStream, OutputStream cipherStream) {
        throw new AlgorithmCallingException("RSA cipher does not support streaming data.");
    }

    public void decrypt(byte[] key, InputStream cipherStream, OutputStream plainStream) {
        throw new AlgorithmCallingException("RSA cipher does not support streaming data.");
    }

    public void encrypt(byte[] key, File plainFile, File cipherFile) {
        throw new AlgorithmCallingException("RSA cipher does not support file data.");
    }

    public void decrypt(byte[] key, File cipherFile, File plainFile) {
        throw new AlgorithmCallingException("RSA cipher does not support streaming data.");
    }
}

