/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api.v1;

import io.soft.algorithm.api.v1.Algorithm;
import io.soft.algorithm.crypto.Digest;
import io.soft.algorithm.crypto.digests.MD5Digest;
import io.soft.algorithm.crypto.digests.SHA1Digest;
import io.soft.algorithm.crypto.digests.SHA224Digest;
import io.soft.algorithm.crypto.digests.SHA256Digest;
import io.soft.algorithm.crypto.digests.SHA384Digest;
import io.soft.algorithm.crypto.digests.SHA512Digest;
import io.soft.algorithm.crypto.digests.SM3Digest;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.util.Checker;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class MessageDigest {
    private static Digest digest;
    private static int DIGEST_LENGTH;

    private MessageDigest(Algorithm alg) {
        switch (alg) {
            case SM3: {
                digest = new SM3Digest();
                DIGEST_LENGTH = 32;
                break;
            }
            case MD5: {
                digest = new MD5Digest();
                DIGEST_LENGTH = 16;
                break;
            }
            case SHA1: {
                digest = new SHA1Digest();
                DIGEST_LENGTH = 20;
                break;
            }
            case SHA224: {
                digest = new SHA224Digest();
                DIGEST_LENGTH = 28;
                break;
            }
            case SHA256: {
                digest = new SHA256Digest();
                DIGEST_LENGTH = 32;
                break;
            }
            case SHA384: {
                digest = new SHA384Digest();
                DIGEST_LENGTH = 48;
                break;
            }
            case SHA512: {
                digest = new SHA512Digest();
                DIGEST_LENGTH = 64;
                break;
            }
            default: {
                throw new AlgorithmCallingException("Algorithm for message digest initial is illegal.");
            }
        }
    }

    public static MessageDigest getInstance(Algorithm alg) {
        return new MessageDigest(alg);
    }

    public byte[] digest(byte[] data) {
        Checker.check(data != null, "the data for message digest can not be null.", new Object[0]);
        byte[] bytes = new byte[DIGEST_LENGTH];
        digest.update(data, 0, data.length);
        digest.doFinal(bytes, 0);
        digest.reset();
        return bytes;
    }

    public byte[] digest(InputStream stream) {
        ByteArrayOutputStream ct = new ByteArrayOutputStream();
        byte[] block = new byte[4096];
        byte[] cipherText = new byte[DIGEST_LENGTH];
        try {
            int c;
            while ((c = stream.read(block)) >= 0) {
                ct.write(block, 0, c);
                cipherText = this.digest(ct.toByteArray());
            }
            byte[] byArray = cipherText;
            return byArray;
        }
        catch (IOException e) {
            throw new AlgorithmCallingException(e.getCause().getMessage());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public byte[] digest(File file) {
        Checker.check(file.exists(), "Path: %s is not exists.", file);
        Checker.check(file.isFile(), "Not Found file.Excepted file,actual directory. Path: %s", file);
        Checker.check(file.canRead(), "Path: %s can not be read.", file);
        FileInputStream in = null;
        try {
            byte[] result;
            in = new FileInputStream(file);
            byte[] byArray = result = this.digest(in);
            return byArray;
        }
        catch (FileNotFoundException e) {
            Checker.check(!file.exists() || !file.isFile() || !file.isFile(), "Unauthorized access.", new Object[0]);
            throw new AlgorithmCallingException("Not Found file." + e.getCause().getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

