/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api.v1;

import io.soft.algorithm.api.v1.AlgorithmHelper;
import io.soft.algorithm.api.v1.KeyPair;
import io.soft.algorithm.asn1.NISTNamedCurves;
import io.soft.algorithm.asn1.SECNamedCurves;
import io.soft.algorithm.asn1.X9ECParameters;
import io.soft.algorithm.crypto.asymmetric.SM2KeyGenerator;
import io.soft.algorithm.crypto.asymmetric.SM2PrivateKey;
import io.soft.algorithm.crypto.asymmetric.SM2PublicKey;
import io.soft.algorithm.crypto.generator.RSAKeyPairGenerator;
import io.soft.algorithm.crypto.params.AsymmetricCipherKeyPair;
import io.soft.algorithm.crypto.params.ECDomainParameters;
import io.soft.algorithm.crypto.params.ECKeyGenerationParameters;
import io.soft.algorithm.crypto.params.ECKeyPairGenerator;
import io.soft.algorithm.crypto.params.ECPrivateKeyParameters;
import io.soft.algorithm.crypto.params.ECPublicKeyParameters;
import io.soft.algorithm.crypto.params.RSAKeyGenerationParameters;
import io.soft.algorithm.crypto.params.RSAKeyParameters;
import io.soft.algorithm.crypto.params.RSAPrivateCrtKeyParameters;
import io.soft.algorithm.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import io.soft.algorithm.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import io.soft.algorithm.jce.ECNamedCurveParameterSpec;
import io.soft.algorithm.jce.ECNamedCurveTable;
import io.soft.algorithm.util.Checker;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;

public abstract class KeyPairGenerator {
    private static KeyPairGenerator keyPairGenerator;

    public abstract KeyPair generator();

    public static KeyPairGenerator getSM2() {
        keyPairGenerator = new SM2Generator();
        return keyPairGenerator;
    }

    public static KeyPairGenerator getRSA(int bits, int publicExponent) {
        Checker.check(bits % 8 == 0 && bits < 8192, "Failed to generate rsa key pair.The bits of the RSA key must be a multiple of 8 and smaller than 8192 bits.", new Object[0]);
        Checker.check(publicExponent > 1, "Failed to generate rsa key pair.The exponent of RSA key must be more than 1.", new Object[0]);
        keyPairGenerator = new RSAGenerator(bits, publicExponent);
        return keyPairGenerator;
    }

    public static KeyPairGenerator getECC(String curve) {
        Checker.check(curve != null, "Failed to generate ECC key pair,Caused by:The curve name is null!", new Object[0]);
        String[] CURVE_NAMES = new String[]{"c2pnb163v1", "c2pnb163v2", "c2pnb163v3", "c2pnb176w1", "c2tnb191v1", "c2tnb191v2", "c2tnb191v3", "c2onb191v4", "c2onb191v5", "c2pnb208w1", "c2tnb239v1", "c2tnb239v2", "c2tnb239v3", "c2onb239v4", "c2onb239v5", "c2pnb272w1", "c2pnb304w1", "c2tnb359v1", "c2pnb368w1", "c2tnb431r1", "sm2p256v1", "prime192v1", "prime192v2", "prime192v3", "prime239v1", "prime239v2", "prime239v3", "prime256v1", "sect163k1", "sect163r1", "sect163r2", "sect193r1", "sect193r2", "sect233k1", "sect233r1", "sect239k1", "sect283k1", "sect283r1", "sect409k1", "sect409r1", "sect571k1", "sect571r1", "secp160k1", "secp160r1", "secp160r2", "secp192k1", "secp192r1", "secp224k1", "secp224r1", "secp256k1", "secp256r1", "secp384r1", "secp521r1", "P-192", "P-224", "P-256", "P-384", "P-512"};
        List<String> list = Arrays.asList(CURVE_NAMES);
        Checker.check(list.contains(curve), "Failed to generate ECC key pair.Caused by:The curve named " + curve + " is not supported to generate ECC key pair!", new Object[0]);
        keyPairGenerator = new ECCGenerator(curve);
        return keyPairGenerator;
    }

    private static ECDomainParameters getECDomainParameters(String curve) {
        if (curve.startsWith("sec")) {
            X9ECParameters x9 = SECNamedCurves.getByName(curve);
            Checker.check(x9 != null, "Can not support curve %s.", curve);
            return new ECDomainParameters(x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
        }
        if (curve.startsWith("P-")) {
            X9ECParameters x9 = NISTNamedCurves.getByName(curve);
            Checker.check(x9 != null, "Can not support curve %s.", curve);
            return new ECDomainParameters(x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
        }
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec(curve);
        Checker.check(spec != null, "Can not support curve %s.", curve);
        return new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN(), spec.getH(), spec.getSeed());
    }

    static class ECCGenerator
    extends KeyPairGenerator {
        private String curve;

        private ECCGenerator(String curve) {
            this.curve = curve;
        }

        public KeyPair generator() {
            ECDomainParameters domainParameters = KeyPairGenerator.getECDomainParameters(this.curve);
            ECKeyPairGenerator generator = new ECKeyPairGenerator();
            ECKeyGenerationParameters parameters = new ECKeyGenerationParameters(domainParameters, new SecureRandom());
            generator.init(parameters);
            AsymmetricCipherKeyPair keyPair = generator.generateKeyPair();
            ECPublicKeyParameters publicKeyParameters = (ECPublicKeyParameters)keyPair.getPublic();
            ECPrivateKeyParameters privateKeyParameters = (ECPrivateKeyParameters)keyPair.getPrivate();
            byte[] publicKey = publicKeyParameters.getQ().getEncoded(false);
            byte[] privateKey = privateKeyParameters.getD().toByteArray();
            return new KeyPair(publicKey, privateKey);
        }
    }

    static class RSAGenerator
    extends KeyPairGenerator {
        int bits;
        int publicExponent;

        private RSAGenerator(int bits, int publicExponent) {
            this.bits = bits;
            this.publicExponent = publicExponent;
        }

        public KeyPair generator() {
            BigInteger exponent = new BigInteger(String.valueOf(this.publicExponent));
            RSAKeyPairGenerator pGen = new RSAKeyPairGenerator();
            RSAKeyGenerationParameters genParam = new RSAKeyGenerationParameters(exponent, new SecureRandom(), this.bits, 100);
            pGen.init(genParam);
            AsymmetricCipherKeyPair pair = pGen.generateKeyPair();
            RSAKeyParameters pub = (RSAKeyParameters)pair.getPublic();
            RSAPrivateCrtKeyParameters rsaPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)pair.getPrivate();
            BCRSAPublicKey pubKey = new BCRSAPublicKey(pub);
            BCRSAPrivateCrtKey priKey = new BCRSAPrivateCrtKey(rsaPrivateCrtKeyParameters);
            byte[] rsaPK = AlgorithmHelper.serializePublicKey(pubKey.getModulus().toByteArray(), this.publicExponent);
            byte[] rsaVK = priKey.getEncoded();
            return new KeyPair(rsaPK, rsaVK);
        }
    }

    static class SM2Generator
    extends KeyPairGenerator {
        SM2Generator() {
        }

        public KeyPair generator() {
            SM2KeyGenerator generator = new SM2KeyGenerator();
            java.security.KeyPair keyPair = generator.generateKeyPair();
            SM2PrivateKey vk = (SM2PrivateKey)keyPair.getPrivate();
            SM2PublicKey pk = (SM2PublicKey)keyPair.getPublic();
            byte[] publicKey = pk.getEncoded();
            byte[] privateKey = vk.getEncoded();
            return new KeyPair(publicKey, privateKey);
        }
    }
}

