/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api.v1;

import io.soft.algorithm.asn1.NISTNamedCurves;
import io.soft.algorithm.asn1.SECNamedCurves;
import io.soft.algorithm.asn1.X9ECParameters;
import io.soft.algorithm.crypto.params.ECDomainParameters;
import io.soft.algorithm.crypto.params.ECPrivateKeyParameters;
import io.soft.algorithm.crypto.params.ECPublicKeyParameters;
import io.soft.algorithm.crypto.params.ParametersWithID;
import io.soft.algorithm.crypto.params.SM2KeyExchange;
import io.soft.algorithm.crypto.params.SM2KeyExchangePrivateParameters;
import io.soft.algorithm.crypto.params.SM2KeyExchangePublicParameters;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.jcajce.provider.asymmetric.ec.KeyAgreementSpi;
import io.soft.algorithm.jce.ECNamedCurveParameterSpec;
import io.soft.algorithm.jce.ECNamedCurveTable;
import io.soft.algorithm.math.ec.ECPoint;
import io.soft.algorithm.util.Checker;
import io.soft.algorithm.util.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class KeyAgreement {
    public static byte[] ecdh(String curve, int keySize, byte[] privateKey, byte[] otherPublicKey, String deriveFunction) throws AlgorithmCallingException {
        ECPoint ecPoint;
        ECDomainParameters domainParameters;
        X9ECParameters x9;
        KeyAgreementSpi keyAgreement;
        Checker.check(keySize > 0, "the keysize for ECC key agreement mosu be more than 0 byte.", new Object[0]);
        Checker.check(privateKey != null, "the private key for ECC key agreement cannot be null.", new Object[0]);
        Checker.check(privateKey.length != 0, "the private key for ECC key agreement must be more than 0 byte.", new Object[0]);
        Checker.check(otherPublicKey != null, "the other public key for ECC key agreement cannot be null.", new Object[0]);
        Checker.check(otherPublicKey.length != 0, "the other public key for ECC key agreement must be more than 0 byte.", new Object[0]);
        Checker.check(deriveFunction != null, "the deriveFunction  key for ECC key agreement can not be null.", new Object[0]);
        Checker.check(deriveFunction.length() > 0, "the deriveFunction  key for ECC key agreement must be more than 0 byte.", new Object[0]);
        if (deriveFunction.equalsIgnoreCase("SHA512")) {
            keyAgreement = new KeyAgreementSpi.DHwithSHA512KDFAndSharedInfo();
        } else if (deriveFunction.equalsIgnoreCase("SHA1")) {
            keyAgreement = new KeyAgreementSpi.DHwithSHA1KDFAndSharedInfo();
        } else if (deriveFunction.equalsIgnoreCase("SHA224")) {
            keyAgreement = new KeyAgreementSpi.DHwithSHA224KDFAndSharedInfo();
        } else if (deriveFunction.equalsIgnoreCase("SHA256")) {
            keyAgreement = new KeyAgreementSpi.DHwithSHA256KDFAndSharedInfo();
        } else if (deriveFunction.equalsIgnoreCase("SHA384")) {
            keyAgreement = new KeyAgreementSpi.DHwithSHA384KDFAndSharedInfo();
        } else if (deriveFunction.equalsIgnoreCase("ECDH")) {
            keyAgreement = new KeyAgreementSpi.DH();
        } else {
            throw new AlgorithmCallingException("ECC key agreement does not support this deriveFunction:" + deriveFunction);
        }
        if (curve.startsWith("sec")) {
            x9 = SECNamedCurves.getByName(curve);
            domainParameters = new ECDomainParameters(x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
            ecPoint = x9.getCurve().decodePoint(otherPublicKey);
        } else if (curve.startsWith("P-")) {
            x9 = NISTNamedCurves.getByName(curve);
            domainParameters = new ECDomainParameters(x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
            ecPoint = x9.getCurve().decodePoint(otherPublicKey);
        } else {
            ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec(curve);
            domainParameters = new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN(), spec.getH(), spec.getSeed());
            ecPoint = spec.getCurve().decodePoint(otherPublicKey);
        }
        ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(new BigInteger(1, privateKey), domainParameters);
        ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters(ecPoint, domainParameters);
        SecureRandom secureRandom = new SecureRandom();
        keyAgreement.engineInit(ecPrivateKeyParameters, secureRandom);
        keyAgreement.engineDoPhase(ecPublicKeyParameters);
        byte[] secret = keyAgreement.engineGenerateSecret();
        byte[] key = keyAgreement.getSharedSecretBytes(secret, null, keySize * 8);
        Checker.check(key != null, "ECC key agreement failed.", new Object[0]);
        return key;
    }

    public static byte[] SM2KeyExchange(boolean organizer, byte[] privateKey, byte[] tempPrivateKey, byte[] otherPublicKey, byte[] otherTempPublicKey, byte[] userId, byte[] otherUserId, int keySize) {
        Checker.check(privateKey != null, "the private key for sm2 key agreement can not be null.", new Object[0]);
        Checker.check(privateKey.length == 32, "the length of private key for sm2 key agreement must be 32 bytes.", new Object[0]);
        Checker.check(tempPrivateKey != null, "the temp private key for sm2 key agreement can not be null.", new Object[0]);
        Checker.check(tempPrivateKey.length == 32, "the temp private key for sm2 key agreement must be 32 bytes.", new Object[0]);
        Checker.check(otherPublicKey != null, "the other public key for sm2 key agreement can not be null.", new Object[0]);
        Checker.check(otherPublicKey.length == 64, "the other public key for sm2 key agreement must be 64 bytes.", new Object[0]);
        Checker.check(otherTempPublicKey != null, "the other temp public key for sm2 key agreement can not be null.", new Object[0]);
        Checker.check(otherTempPublicKey.length == 64, "the other temp public key for sm2 key agreement must be 64 bytes.", new Object[0]);
        Checker.check(keySize > 0, "the keySize of sm2 key agreement must be more than 0 byte.", new Object[0]);
        Checker.check(userId != null, "the user id for SM2 key agreement cannot be null.", new Object[0]);
        Checker.check(userId.length > 0, "the length of user id for SM2 key agreement cannot be null.", new Object[0]);
        Checker.check(otherUserId != null, "the other user id for SM2 key agreement can not be null.", new Object[0]);
        Checker.check(otherUserId.length > 0, "the length of other user id for SM2 key agreement cannot be null.", new Object[0]);
        byte[] tByte = new byte[65];
        tByte[0] = 4;
        System.arraycopy(otherPublicKey, 0, tByte, 1, otherPublicKey.length);
        byte[] iByte = new byte[65];
        iByte[0] = 4;
        System.arraycopy(otherTempPublicKey, 0, iByte, 1, otherTempPublicKey.length);
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec("sm2p256v1");
        ECDomainParameters domainParameters = new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN(), spec.getH(), spec.getSeed());
        ECPrivateKeyParameters myPribKey = new ECPrivateKeyParameters(new BigInteger(1, privateKey), domainParameters);
        ECPrivateKeyParameters myTPribKey = new ECPrivateKeyParameters(new BigInteger(1, tempPrivateKey), domainParameters);
        ECPoint otherPub = spec.getCurve().decodePoint(Hex.decode("04" + Hex.encode(otherPublicKey)));
        ECPublicKeyParameters otherPubKey = new ECPublicKeyParameters(otherPub, domainParameters);
        ECPoint otherePub = spec.getCurve().decodePoint(Hex.decode("04" + Hex.encode(otherTempPublicKey)));
        ECPublicKeyParameters otherTpubKey = new ECPublicKeyParameters(otherePub, domainParameters);
        SM2KeyExchange keyExchange = new SM2KeyExchange();
        SM2KeyExchangePrivateParameters cipherParameters1 = new SM2KeyExchangePrivateParameters(organizer, myPribKey, myTPribKey);
        ParametersWithID cipherParameters2 = new ParametersWithID(cipherParameters1, userId);
        keyExchange.init(cipherParameters2);
        SM2KeyExchangePublicParameters cipherParameters3 = new SM2KeyExchangePublicParameters(otherPubKey, otherTpubKey);
        ParametersWithID cipherParameters4 = new ParametersWithID(cipherParameters3, otherUserId);
        byte[] key = keyExchange.calculateKey(keySize * 8, cipherParameters4);
        Checker.check(key != null, "sm2 key agreement failed.", new Object[0]);
        return key;
    }
}

