/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api.v1;

import io.soft.algorithm.api.v1.Algorithm;
import io.soft.algorithm.api.v1.MAC;
import io.soft.algorithm.crypto.digests.MD5Digest;
import io.soft.algorithm.crypto.digests.SHA1Digest;
import io.soft.algorithm.crypto.digests.SHA224Digest;
import io.soft.algorithm.crypto.digests.SHA256Digest;
import io.soft.algorithm.crypto.digests.SHA384Digest;
import io.soft.algorithm.crypto.digests.SHA512Digest;
import io.soft.algorithm.crypto.digests.SM3Digest;
import io.soft.algorithm.crypto.macs.HMac;
import io.soft.algorithm.crypto.params.KeyParameter;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.util.Checker;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class Hmac
extends MAC {
    private Algorithm alg;

    public Hmac(Algorithm alg) {
        this.alg = alg;
        switch (alg) {
            case SHA1: {
                this.digest = new SHA1Digest();
                break;
            }
            case MD5: {
                this.digest = new MD5Digest();
                break;
            }
            case SHA224: {
                this.digest = new SHA224Digest();
                break;
            }
            case SHA256: {
                this.digest = new SHA256Digest();
                break;
            }
            case SHA384: {
                this.digest = new SHA384Digest();
                break;
            }
            case SHA512: {
                this.digest = new SHA512Digest();
                break;
            }
            case SM3: {
                this.digest = new SM3Digest();
                break;
            }
            default: {
                throw new AlgorithmCallingException("Algorithm for mac initial is illegal.");
            }
        }
    }

    private byte[] hmac(byte[] key, byte[] data) {
        Checker.check(data != null, "the data for hmac can not be null.", new Object[0]);
        Checker.check(key != null, "the key for hmac can not be null.", new Object[0]);
        Checker.check(this.digest != null, "Algorithm for mac must be initialized before mac cipher", new Object[0]);
        HMac mac = new HMac(this.digest);
        byte[] resBuf = new byte[mac.getMacSize()];
        mac.init(new KeyParameter(key));
        mac.update(data, 0, data.length);
        mac.doFinal(resBuf, 0);
        mac.reset();
        return resBuf;
    }

    public byte[] mac(byte[] key, byte[] data) {
        return this.hmac(key, data);
    }

    public byte[] mac(byte[] key, InputStream stream) {
        ByteArrayOutputStream ct = new ByteArrayOutputStream();
        byte[] block = new byte[4096];
        byte[] cipherText = null;
        try {
            int c;
            while ((c = stream.read(block)) >= 0) {
                ct.write(block, 0, c);
                cipherText = this.hmac(key, ct.toByteArray());
            }
            byte[] byArray = cipherText;
            return byArray;
        }
        catch (IOException e) {
            throw new AlgorithmCallingException(e.getCause().getMessage());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public byte[] mac(byte[] key, File file) {
        Checker.check(file.exists(), "Path: %s is not exists.", file);
        Checker.check(file.isFile(), "Not Found file.Excepted file,actual directory. Path: %s", file);
        Checker.check(file.canRead(), "Path: %s can not be read.", file);
        FileInputStream in = null;
        try {
            byte[] result;
            in = new FileInputStream(file);
            byte[] byArray = result = this.mac(key, in);
            return byArray;
        }
        catch (FileNotFoundException e) {
            Checker.check(!file.exists() || !file.isFile(), "Unauthorized access.", new Object[0]);
            throw new AlgorithmCallingException("Not Found file." + e.getCause().getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

