/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api.v1;

import io.soft.algorithm.api.v1.Algorithm;
import io.soft.algorithm.api.v1.MessageDigest;
import io.soft.algorithm.api.v1.Signature;
import io.soft.algorithm.asn1.NISTNamedCurves;
import io.soft.algorithm.asn1.SECNamedCurves;
import io.soft.algorithm.asn1.X9ECParameters;
import io.soft.algorithm.crypto.Digest;
import io.soft.algorithm.crypto.digests.MD5Digest;
import io.soft.algorithm.crypto.digests.NullDigest;
import io.soft.algorithm.crypto.digests.SHA1Digest;
import io.soft.algorithm.crypto.digests.SHA224Digest;
import io.soft.algorithm.crypto.digests.SHA256Digest;
import io.soft.algorithm.crypto.digests.SHA384Digest;
import io.soft.algorithm.crypto.digests.SHA512Digest;
import io.soft.algorithm.crypto.digests.SM3Digest;
import io.soft.algorithm.crypto.params.ECDomainParameters;
import io.soft.algorithm.crypto.params.ECPrivateKeyParameters;
import io.soft.algorithm.crypto.params.ECPublicKeyParameters;
import io.soft.algorithm.crypto.params.ParametersWithRandom;
import io.soft.algorithm.crypto.signers.DSADigestSigner;
import io.soft.algorithm.crypto.signers.ECDSASigner;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.jce.ECNamedCurveParameterSpec;
import io.soft.algorithm.jce.ECNamedCurveTable;
import io.soft.algorithm.util.Checker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;

class ECCSignature
extends Signature {
    private String curve = null;
    private Digest digest;
    private Algorithm alg;

    public ECCSignature(Algorithm hashAlg) {
        this.alg = hashAlg;
        switch (hashAlg) {
            case NONE: {
                this.digest = new NullDigest();
                break;
            }
            case SM3: {
                this.digest = new SM3Digest();
                break;
            }
            case SHA1: {
                this.digest = new SHA1Digest();
                break;
            }
            case SHA224: {
                this.digest = new SHA224Digest();
                break;
            }
            case SHA256: {
                this.digest = new SHA256Digest();
                break;
            }
            case SHA384: {
                this.digest = new SHA384Digest();
                break;
            }
            case SHA512: {
                this.digest = new SHA512Digest();
                break;
            }
            case MD5: {
                this.digest = new MD5Digest();
            }
        }
    }

    public Signature setCurve(String curve) {
        Checker.check(curve != null, "The curve name for ecc signature cannot be set as null!", new Object[0]);
        String[] CURVE_NAMES = new String[]{"c2pnb163v1", "c2pnb163v2", "c2pnb163v3", "c2pnb176w1", "c2tnb191v1", "c2tnb191v2", "c2tnb191v3", "c2onb191v4", "c2onb191v5", "c2pnb208w1", "c2tnb239v1", "c2tnb239v2", "c2tnb239v3", "c2onb239v4", "c2onb239v5", "c2pnb272w1", "c2pnb304w1", "c2tnb359v1", "c2pnb368w1", "c2tnb431r1", "sm2p256v1", "prime192v1", "prime192v2", "prime192v3", "prime239v1", "prime239v2", "prime239v3", "prime256v1", "sect163k1", "sect163r1", "sect163r2", "sect193r1", "sect193r2", "sect233k1", "sect233r1", "sect239k1", "sect283k1", "sect283r1", "sect409k1", "sect409r1", "sect571k1", "sect571r1", "secp160k1", "secp160r1", "secp160r2", "secp192k1", "secp192r1", "secp224k1", "secp224r1", "secp256k1", "secp256r1", "secp384r1", "secp521r1", "P-192", "P-224", "P-256", "P-384", "P-512"};
        List<String> list = Arrays.asList(CURVE_NAMES);
        Checker.check(list.contains(curve), "The curve named " + curve + " is not supported for ECC signature.", new Object[0]);
        this.curve = curve;
        return super.setCurve(curve);
    }

    private static ECDomainParameters getECDomainParameters(String curve) {
        if (curve.startsWith("sec")) {
            X9ECParameters x9 = SECNamedCurves.getByName(curve);
            return new ECDomainParameters(x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
        }
        if (curve.startsWith("P-")) {
            X9ECParameters x9 = NISTNamedCurves.getByName(curve);
            return new ECDomainParameters(x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
        }
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec(curve);
        return new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN(), spec.getH(), spec.getSeed());
    }

    public byte[] sign(byte[] privateKey, byte[] data) {
        Checker.check(this.curve != null, "ECC curve is not initialized.", new Object[0]);
        ECDomainParameters params = ECCSignature.getECDomainParameters(this.curve);
        ECPrivateKeyParameters priKey = new ECPrivateKeyParameters(new BigInteger(1, privateKey), params);
        SecureRandom k = new SecureRandom();
        DSADigestSigner dsa = new DSADigestSigner(new ECDSASigner(), this.digest);
        dsa.init(true, new ParametersWithRandom(priKey, k));
        dsa.update(data, 0, data.length);
        return dsa.generateSignature();
    }

    public boolean verify(byte[] publicKey, byte[] data, byte[] sign) {
        ECDomainParameters params = ECCSignature.getECDomainParameters(this.curve);
        ECPublicKeyParameters pubKey = new ECPublicKeyParameters(params.getCurve().decodePoint(publicKey), params);
        DSADigestSigner dsa = new DSADigestSigner(new ECDSASigner(), this.digest);
        dsa.init(false, pubKey);
        dsa.update(data, 0, data.length);
        return dsa.verifySignature(sign);
    }

    public byte[] sign(byte[] privateKey, InputStream stream) {
        Checker.check(this.alg != Algorithm.NONE, "Elliptic Curve does not support signatures for calculate streaming data when the algorithm is NONE.", new Object[0]);
        MessageDigest messageDigest = MessageDigest.getInstance(this.alg);
        byte[] hash = messageDigest.digest(stream);
        return this.sign(privateKey, hash);
    }

    public boolean verify(byte[] publicKey, InputStream stream, byte[] sign) {
        Checker.check(this.alg != Algorithm.NONE, "Elliptic Curve does not support signatures for calculate streaming data when the algorithm is NONE.", new Object[0]);
        MessageDigest messageDigest = MessageDigest.getInstance(this.alg);
        byte[] hash = messageDigest.digest(stream);
        return this.verify(publicKey, hash, sign);
    }

    public byte[] sign(byte[] privateKey, File file) {
        Checker.check(this.alg != Algorithm.NONE, "Elliptic Curve signature does not support digest streaming data when the algorithm is NONE.", new Object[0]);
        Checker.check(file.exists(), "Path: %s is not exists.", file);
        Checker.check(file.isFile(), "Not Found file.Excepted file,actual directory. Path: %s", file);
        Checker.check(file.canRead(), "Path: %s can not be read.", file);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] byArray = this.sign(privateKey, in);
            return byArray;
        }
        catch (FileNotFoundException e) {
            Checker.check(!file.exists() || !file.isFile(), "Unauthorized access.", new Object[0]);
            throw new AlgorithmCallingException("Not Found file.", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean verify(byte[] publicKey, File file, byte[] sign) {
        Checker.check(this.alg != Algorithm.NONE, "Elliptic Curve signature does not support digest streaming data when the algorithm is NONE.", new Object[0]);
        Checker.check(file.exists(), "Path: %s is not exists.", file);
        Checker.check(file.isFile(), "Not Found file.Excepted file,actual directory. Path: %s", file);
        Checker.check(file.canRead(), "Path: %s can not be read.", file);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            boolean bl = this.verify(publicKey, in, sign);
            return bl;
        }
        catch (FileNotFoundException e) {
            Checker.check(!file.exists() || !file.isFile(), "Unauthorized access.", new Object[0]);
            throw new AlgorithmCallingException("Not Found file.", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

