/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api.v1;

import io.soft.algorithm.api.Padding;
import io.soft.algorithm.api.v1.Cipher;
import io.soft.algorithm.api.v1.Mode;
import io.soft.algorithm.crypto.paddings.BlockCipherPadding;
import io.soft.algorithm.crypto.paddings.ISO10126d2Padding;
import io.soft.algorithm.crypto.paddings.ISO7816d4Padding;
import io.soft.algorithm.crypto.paddings.PKCS7Padding;
import io.soft.algorithm.crypto.paddings.X923Padding;
import io.soft.algorithm.crypto.paddings.ZeroBytePadding;
import io.soft.algorithm.crypto.symmetric.DESede;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.util.Checker;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class DESedeCipher
extends Cipher {
    private byte[] IV = null;
    private Padding padding;
    private Mode mode;
    private BlockCipherPadding blockCipherPadding;

    public DESedeCipher(Mode mode, Padding padding) {
        this.mode = mode;
        this.padding = padding;
        this.initPadding();
    }

    private void initPadding() {
        switch (this.padding) {
            case NoPadding: {
                this.blockCipherPadding = null;
                break;
            }
            case PKCS7Padding: 
            case PKCS5Padding: {
                this.blockCipherPadding = new PKCS7Padding();
                break;
            }
            case ZeroPadding: 
            case OptionalZeroPadding: {
                this.blockCipherPadding = new ZeroBytePadding();
                break;
            }
            case ISO_ICE_7816d4Padding: {
                this.blockCipherPadding = new ISO7816d4Padding();
                break;
            }
            case Ansix923Padding: {
                this.blockCipherPadding = new X923Padding();
                break;
            }
            case ISO10126Padding: {
                this.blockCipherPadding = new ISO10126d2Padding();
                break;
            }
            default: {
                throw new AlgorithmCallingException("DESede cipher does not support this padding:" + this.padding);
            }
        }
    }

    public Cipher setIv(byte[] iv) {
        this.IV = iv;
        return this;
    }

    public Cipher setAad(byte[] add) {
        throw new AlgorithmCallingException("Can not support set aad with DES.");
    }

    private byte[] doFinal(boolean isEncryption, byte[] key, byte[] data) {
        switch (this.mode) {
            case ECB: {
                if (this.padding == Padding.OptionalZeroPadding && data.length % 8 == 0 && isEncryption) {
                    this.blockCipherPadding = null;
                }
                return DESede.doFinalWithECB(data, key, isEncryption, this.blockCipherPadding);
            }
            case CBC: {
                Checker.check(this.IV != null, "the iv for 3DES CBC can not be null or  did not setIV.", new Object[0]);
                Checker.check(this.IV.length == 8, "the length of iv for DESede CBC must be 8 bytes.", new Object[0]);
                if (this.padding == Padding.OptionalZeroPadding && data.length % 8 == 0 && isEncryption) {
                    this.blockCipherPadding = null;
                }
                return DESede.doFinalWithCBC(data, key, this.IV, isEncryption, this.blockCipherPadding);
            }
            case CFB: {
                Checker.check(this.IV != null, "the iv for 3DES CFB can not be null or did not setIV.", new Object[0]);
                Checker.check(this.IV.length == 8, "the length of iv for DESede CFB must be 8 bytes.", new Object[0]);
                if (this.padding == Padding.OptionalZeroPadding && data.length % 8 == 0 && isEncryption) {
                    this.blockCipherPadding = null;
                }
                return DESede.doFinalWithCFB(data, key, this.IV, isEncryption, this.blockCipherPadding);
            }
            case OFB: {
                Checker.check(this.IV != null, "the iv for 3DES OFB can not be null or did not setIV.", new Object[0]);
                Checker.check(this.IV.length == 8, "the length of iv for 3DES OFB must be 8 bytes.", new Object[0]);
                if (this.padding == Padding.OptionalZeroPadding && data.length % 8 == 0 && isEncryption) {
                    this.blockCipherPadding = null;
                }
                return DESede.doFinalWithOFB(data, key, this.IV, isEncryption, this.blockCipherPadding);
            }
            case CTR: {
                if (this.padding == Padding.OptionalZeroPadding && data.length % 8 == 0 && isEncryption) {
                    this.blockCipherPadding = null;
                }
                if (this.IV == null) {
                    return DESede.doFinalWithCTR(data, key, new byte[8], isEncryption, this.blockCipherPadding);
                }
                Checker.check(this.IV.length == 8, "the length of iv for 3DES CTR must be 8 bytes.", new Object[0]);
                return DESede.doFinalWithCTR(data, key, this.IV, isEncryption, this.blockCipherPadding);
            }
        }
        throw new AlgorithmCallingException("3DES cipher does not support this mode:" + (Object)((Object)this.mode));
    }

    public byte[] encrypt(byte[] key, byte[] data) {
        return this.doFinal(true, key, data);
    }

    public byte[] decrypt(byte[] key, byte[] data) {
        return this.doFinal(false, key, data);
    }

    private void doFinalWithStream(boolean isEncryption, byte[] key, InputStream plainStream, OutputStream cipherStream) {
        ByteArrayOutputStream ct = new ByteArrayOutputStream();
        byte[] block = new byte[4096];
        try {
            int c;
            while ((c = plainStream.read(block)) >= 0) {
                ct.write(block, 0, c);
                byte[] cipherText = !isEncryption ? this.decrypt(key, ct.toByteArray()) : this.encrypt(key, ct.toByteArray());
                cipherStream.write(cipherText);
            }
            cipherStream.flush();
        }
        catch (IOException e) {
            throw new AlgorithmCallingException("3DES calculate cipher stream failed!", e);
        }
        finally {
            if (plainStream != null) {
                try {
                    plainStream.close();
                }
                catch (IOException iOException) {}
            }
            if (cipherStream != null) {
                try {
                    cipherStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void encrypt(byte[] key, InputStream plainStream, OutputStream cipherStream) {
        this.doFinalWithStream(true, key, plainStream, cipherStream);
    }

    public void decrypt(byte[] key, InputStream cipherStream, OutputStream plainStream) {
        this.doFinalWithStream(false, key, cipherStream, plainStream);
    }

    private void doFinalWithFile(boolean isEncryption, byte[] key, File srcFile, File desFile) {
        Checker.check(srcFile.exists(), "Path: %s is not exists.", srcFile);
        Checker.check(srcFile.isFile(), "Not Found file.Excepted file,actual directory. Path: %s", srcFile);
        Checker.check(srcFile.canRead(), "Path: %s can not be read.", srcFile);
        if (!desFile.exists()) {
            try {
                boolean res = desFile.createNewFile();
                Checker.check(res, "Failed to create the file.", new Object[0]);
            }
            catch (IOException e) {
                throw new AlgorithmCallingException("Failed to create the file.", e);
            }
        }
        Checker.check(desFile.isFile(), "Not Found file..Excepted file,actual directory. Path: %s", desFile);
        Checker.check(desFile.canWrite(), "Path: %s is not writable.", desFile);
        FileInputStream in = null;
        FileOutputStream fileOutputStream = null;
        try {
            in = new FileInputStream(srcFile);
            fileOutputStream = new FileOutputStream(desFile);
            if (isEncryption) {
                this.encrypt(key, in, fileOutputStream);
            } else {
                this.decrypt(key, in, fileOutputStream);
            }
        }
        catch (FileNotFoundException e) {
            Checker.check(!srcFile.exists() || !desFile.isFile() || !srcFile.isFile(), "Unauthorized access.", new Object[0]);
            throw new AlgorithmCallingException("Not Found file.", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void encrypt(byte[] key, File plainFile, File cipherFile) {
        this.doFinalWithFile(true, key, plainFile, cipherFile);
    }

    public void decrypt(byte[] key, File cipherFile, File plainFile) {
        this.doFinalWithFile(false, key, plainFile, cipherFile);
    }
}

