/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api.v1;

import io.soft.algorithm.api.v1.Algorithm;
import io.soft.algorithm.api.v1.MAC;
import io.soft.algorithm.crypto.BlockCipher;
import io.soft.algorithm.crypto.engines.AESEngine;
import io.soft.algorithm.crypto.engines.DESedeEngine;
import io.soft.algorithm.crypto.engines.SM4Engine;
import io.soft.algorithm.crypto.macs.CMac;
import io.soft.algorithm.crypto.params.KeyParameter;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.util.Checker;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class Cmac
extends MAC {
    private BlockCipher blockCipher;
    private int macSize = 128;
    private Algorithm alg;

    public Cmac(Algorithm algorithm) {
        this.alg = algorithm;
        switch (algorithm) {
            case SM4: {
                this.blockCipher = new SM4Engine();
                break;
            }
            case DESede: {
                this.blockCipher = new DESedeEngine();
                this.macSize = 64;
                break;
            }
            case AES: {
                this.blockCipher = new AESEngine();
                break;
            }
            default: {
                throw new AlgorithmCallingException("Algorithm for mac may be not initialized or illegal.");
            }
        }
    }

    public byte[] cmac(byte[] key, byte[] data) {
        Checker.check(this.blockCipher != null, "Algorithm for mac must be initialized before mac cipher", new Object[0]);
        Checker.check(key != null, "the key for cmac can not be null.", new Object[0]);
        if (key.length != this.blockCipher.getBlockSize()) {
            if (this.alg == Algorithm.AES || this.alg == Algorithm.SM4) {
                throw new AlgorithmCallingException("the length of key for cmac not block size aligned.");
            }
            if (key.length != 16 && key.length != 24) {
                throw new AlgorithmCallingException("the length of key for cmac not block size aligned.");
            }
        }
        Checker.check(data != null, "the data for cmac can not be null.", new Object[0]);
        Checker.check(data.length != 0, "the data for cmac must be more than 0 byte.", new Object[0]);
        CMac mac = new CMac(this.blockCipher, this.macSize);
        KeyParameter keyParameter = new KeyParameter(key);
        mac.init(keyParameter);
        mac.update(data, 0, data.length);
        byte[] out = new byte[16];
        mac.doFinal(out, 0);
        return out;
    }

    public byte[] mac(byte[] key, byte[] data) {
        return this.cmac(key, data);
    }

    public byte[] mac(byte[] key, InputStream stream) {
        ByteArrayOutputStream ct = new ByteArrayOutputStream();
        byte[] block = new byte[4096];
        byte[] cipherText = null;
        try {
            int c;
            while ((c = stream.read(block)) >= 0) {
                ct.write(block, 0, c);
                cipherText = this.cmac(key, ct.toByteArray());
            }
            byte[] byArray = cipherText;
            return byArray;
        }
        catch (IOException e) {
            throw new AlgorithmCallingException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public byte[] mac(byte[] key, File file) {
        Checker.check(file.exists(), "Path: %s is not exists.", file);
        Checker.check(file.isFile(), "Not Found file.Excepted file,actual directory. Path: %s", file);
        Checker.check(file.canRead(), "Path: %s can not be read.", file);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] byArray = this.mac(key, in);
            return byArray;
        }
        catch (FileNotFoundException e) {
            Checker.check(!file.exists() || !file.isFile() || !file.isFile(), "Unauthorized access.", new Object[0]);
            throw new AlgorithmCallingException("Not Found file.", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

