/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api.v1;

import io.soft.algorithm.api.DataPadding;
import io.soft.algorithm.api.Padding;
import io.soft.algorithm.api.RSAPadding;
import io.soft.algorithm.api.v1.AESCipher;
import io.soft.algorithm.api.v1.Algorithm;
import io.soft.algorithm.api.v1.DESedeCipher;
import io.soft.algorithm.api.v1.Mode;
import io.soft.algorithm.api.v1.RSACipher;
import io.soft.algorithm.api.v1.SM2Cipher;
import io.soft.algorithm.api.v1.SM4Cipher;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.util.Checker;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Cipher {
    public static Cipher getInstance(Algorithm alg, Mode mode, DataPadding padding) {
        switch (alg) {
            case SM2: {
                Checker.check(padding == Padding.NoPadding, "SM2 cipher only support the NoPadding.", new Object[0]);
                Checker.check(mode == Mode.NONE, "SM2 cipher only support the NONE mode.", new Object[0]);
                return new SM2Cipher();
            }
            case RSA: {
                Checker.check(mode == Mode.NONE, "RSA cipher only support the NONE mode.", new Object[0]);
                return new RSACipher((RSAPadding)padding);
            }
            case ECC: {
                throw new AlgorithmCallingException("There is no support for Algorithm ECC cipher.");
            }
            case AES: {
                Checker.check(mode != Mode.NONE, "AES cipher does not support Mode.NONE.", new Object[0]);
                Checker.check(padding != null, "the padding can not be null.", new Object[0]);
                return new AESCipher(mode, (Padding)padding);
            }
            case DESede: {
                Checker.check(mode != Mode.NONE, "3DES cipher does not support Mode.NONE.", new Object[0]);
                Checker.check(mode != Mode.GCM, "3DES cipher does not support GCM mode.", new Object[0]);
                Checker.check(padding != null, "the padding can not be null.", new Object[0]);
                return new DESedeCipher(mode, (Padding)padding);
            }
            case SM4: {
                Checker.check(mode != Mode.NONE, "SM4 cipher does not support Mode.NONE.", new Object[0]);
                Checker.check(padding != null, "the padding can not be null.", new Object[0]);
                return new SM4Cipher(mode, (Padding)padding);
            }
        }
        throw new AlgorithmCallingException("Cipher does not support this algorithm:" + (Object)((Object)alg));
    }

    public abstract Cipher setIv(byte[] var1);

    public abstract Cipher setAad(byte[] var1);

    public abstract byte[] encrypt(byte[] var1, byte[] var2);

    public abstract byte[] decrypt(byte[] var1, byte[] var2);

    public abstract void encrypt(byte[] var1, InputStream var2, OutputStream var3);

    public abstract void decrypt(byte[] var1, InputStream var2, OutputStream var3);

    public abstract void encrypt(byte[] var1, File var2, File var3);

    public abstract void decrypt(byte[] var1, File var2, File var3);
}

