/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api.v1;

import io.soft.algorithm.asn1.ASN1EncodableVector;
import io.soft.algorithm.asn1.ASN1InputStream;
import io.soft.algorithm.asn1.ASN1Integer;
import io.soft.algorithm.asn1.ASN1Sequence;
import io.soft.algorithm.asn1.DERSequence;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.util.Checker;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgorithmHelper {
    private byte[] C1C2C3ToC1C3C2(byte[] cipherText) throws AlgorithmCallingException {
        Checker.check(cipherText != null && cipherText.length >= 96, "SM2 cipher text error, must be more than 95 bytes and in the format C1||C3||C2.", new Object[0]);
        byte[] bytes = new byte[cipherText.length];
        System.arraycopy(cipherText, 0, bytes, 0, 64);
        System.arraycopy(cipherText, cipherText.length - 32, bytes, 64, 32);
        System.arraycopy(cipherText, 64, bytes, 96, cipherText.length - 96);
        return bytes;
    }

    private byte[] C1C3C2ToC1C2C3(byte[] cipherText) throws AlgorithmCallingException {
        Checker.check(cipherText != null && cipherText.length >= 96, "SM2 cipher text error, must be more than 95 bytes and in the format C1||C3||C2.", new Object[0]);
        byte[] bytes = new byte[cipherText.length];
        System.arraycopy(cipherText, 0, bytes, 0, 64);
        System.arraycopy(cipherText, 96, bytes, 64, cipherText.length - 96);
        System.arraycopy(cipherText, 64, bytes, cipherText.length - 32, 32);
        return bytes;
    }

    private static byte[] format(byte[] value) {
        if (value.length != 32) {
            byte[] bytes = new byte[32];
            if (value.length > 32) {
                System.arraycopy(value, value.length - 32, bytes, 0, 32);
            } else {
                System.arraycopy(value, 0, bytes, 32 - value.length, value.length);
            }
            return bytes;
        }
        return value;
    }

    public static byte[] parseDerSign(byte[] derSign) {
        ASN1InputStream stream = new ASN1InputStream(new ByteArrayInputStream(derSign));
        try {
            ASN1Sequence asn1Sequence = (ASN1Sequence)stream.readObject();
            Enumeration enumeration = asn1Sequence.getObjects();
            BigInteger R = ((ASN1Integer)enumeration.nextElement()).getValue();
            BigInteger S = ((ASN1Integer)enumeration.nextElement()).getValue();
            byte[] bytes = new byte[64];
            byte[] r = AlgorithmHelper.format(R.toByteArray());
            byte[] s = AlgorithmHelper.format(S.toByteArray());
            System.arraycopy(r, 0, bytes, 0, 32);
            System.arraycopy(s, 0, bytes, 32, 32);
            return bytes;
        }
        catch (Exception e) {
            throw new AlgorithmCallingException("DER encoded data encoding or decoding error.");
        }
    }

    public static byte[] serialDerSign(byte[] rs) {
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        System.arraycopy(rs, 0, r, 0, 32);
        System.arraycopy(rs, 32, s, 0, 32);
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(new ASN1Integer(new BigInteger(1, r)));
        vector.add(new ASN1Integer(new BigInteger(1, s)));
        try {
            return new DERSequence(vector).getEncoded();
        }
        catch (IOException e) {
            throw new AlgorithmCallingException("DER encoded data encoding or decoding error.");
        }
    }

    public static byte[] parseDerPublicKey(byte[] rsaDerPublicKey) {
        Checker.check(rsaDerPublicKey != null, String.valueOf("public key must not be null."), new Object[0]);
        int offset = 0;
        Checker.check(rsaDerPublicKey.length > 64 && rsaDerPublicKey[offset] == 48, "the length of publicKey less than 1 or derPublicKey[0] != 0x30.", new Object[0]);
        List<Integer> lists = AlgorithmHelper.getLength(rsaDerPublicKey, ++offset);
        int len = lists.get(0);
        offset = lists.get(1);
        if (rsaDerPublicKey.length - offset != len) {
            throw new AlgorithmCallingException(String.valueOf("illegal der public key."));
        }
        if (rsaDerPublicKey[offset] != 2) {
            throw new AlgorithmCallingException(String.format("illegal der public key, index: %d != 0x02.", offset));
        }
        lists = AlgorithmHelper.getLength(rsaDerPublicKey, ++offset);
        len = lists.get(0);
        offset = lists.get(1);
        if (rsaDerPublicKey[offset] == 0) {
            ++offset;
            --len;
        }
        byte[] modulus = new byte[len];
        System.arraycopy(rsaDerPublicKey, offset, modulus, 0, len);
        return modulus;
    }

    public static List<byte[]> parsePublicKey(byte[] derPublicKey) {
        Checker.check(derPublicKey != null, "public key must not be null.", new Object[0]);
        int offset = 0;
        Checker.check(derPublicKey.length > 64 && derPublicKey[offset] == 48, "the length of publicKey less than 1 or derPublicKey[0] != 0x30.", new Object[0]);
        List<Integer> lists = AlgorithmHelper.getLength(derPublicKey, ++offset);
        int len = lists.get(0);
        offset = lists.get(1);
        Checker.check(derPublicKey.length - offset == len, "illegal der public key.", new Object[0]);
        Checker.check(derPublicKey[offset] == 2, "illegal der public key, index: %d != 0x02.", offset);
        lists = AlgorithmHelper.getLength(derPublicKey, ++offset);
        len = lists.get(0);
        offset = lists.get(1);
        if (derPublicKey[offset] == 0) {
            ++offset;
            --len;
        }
        byte[] modulus = new byte[len];
        System.arraycopy(derPublicKey, offset, modulus, 0, len);
        Checker.check(derPublicKey[offset += len] == 2, "illegal der public key, index: %d != 0x02.", offset);
        lists = AlgorithmHelper.getLength(derPublicKey, ++offset);
        len = lists.get(0);
        offset = lists.get(1);
        if (derPublicKey[offset] == 0) {
            ++offset;
            --len;
        }
        byte[] exponent = new byte[len];
        System.arraycopy(derPublicKey, offset, exponent, 0, len);
        ArrayList<byte[]> publicKey = new ArrayList<byte[]>();
        publicKey.add(modulus);
        publicKey.add(exponent);
        return Collections.unmodifiableList(publicKey);
    }

    static List<Integer> getLength(byte[] bytes, int offset) {
        int len = 0;
        if (bytes[offset] < 0) {
            int llen = bytes[offset] & 0x7F;
            ++offset;
            for (int i = 0; i < llen; ++i) {
                int tmp = bytes[offset + i] & 0xFF;
                len |= tmp << 8 * (llen - 1 - i);
            }
            offset += llen;
        } else {
            len = bytes[offset];
            ++offset;
        }
        ArrayList<Integer> lists = new ArrayList<Integer>();
        lists.add(len);
        lists.add(offset);
        return Collections.unmodifiableList(lists);
    }

    public static byte[] serializePublicKey(byte[] modulus, int publicKeyExponent) {
        BigInteger exponent = new BigInteger(String.valueOf(publicKeyExponent));
        byte[] smodulus = AlgorithmHelper.serialize0x02(modulus);
        byte[] sexponent = AlgorithmHelper.serialize0x02(exponent.toByteArray());
        int len = smodulus.length + sexponent.length;
        byte[] blen = BigInteger.valueOf(len).toByteArray();
        byte[] derPublicKey = new byte[len += blen.length + 1 + (blen[0] != 0 && blen.length > 1 ? 1 : 0)];
        int offset = 0;
        derPublicKey[offset] = 48;
        ++offset;
        if (blen[0] == 0 || blen.length > 1) {
            int lblen = blen[0] == 0 ? blen.length - 1 : blen.length;
            derPublicKey[offset] = (byte)(0x80 ^ lblen);
            System.arraycopy(blen, blen[0] == 0 ? 1 : 0, derPublicKey, ++offset, lblen);
            offset += lblen;
        } else {
            System.arraycopy(blen, 0, derPublicKey, offset, 1);
            ++offset;
        }
        System.arraycopy(smodulus, 0, derPublicKey, offset, smodulus.length);
        System.arraycopy(sexponent, 0, derPublicKey, offset += smodulus.length, sexponent.length);
        return derPublicKey;
    }

    static byte[] serialize0x02(byte[] bytes) {
        int len = bytes.length;
        byte[] blen = BigInteger.valueOf(len += bytes[0] < 0 ? 1 : 0).toByteArray();
        byte[] sbytes = new byte[(len += blen.length + (blen[0] != 0 && blen.length > 1 ? 1 : 0)) + 1];
        int offset = 0;
        sbytes[offset] = 2;
        ++offset;
        if (blen[0] == 0 || blen.length > 1) {
            int lblen = blen[0] == 0 ? blen.length - 1 : blen.length;
            sbytes[offset] = (byte)(0x80 ^ lblen);
            System.arraycopy(blen, blen[0] == 0 ? 1 : 0, sbytes, ++offset, lblen);
            offset += lblen;
        } else {
            System.arraycopy(blen, 0, sbytes, offset, 1);
            ++offset;
        }
        if (bytes[0] < 0) {
            sbytes[offset] = 0;
            ++offset;
        }
        System.arraycopy(bytes, 0, sbytes, offset, bytes.length);
        return sbytes;
    }
}

