/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api;

import io.soft.algorithm.api.AESSymmetricKey;
import io.soft.algorithm.api.DESedeSymmetricKey;
import io.soft.algorithm.api.Padding;
import io.soft.algorithm.api.SM4SymmetricKey;
import io.soft.algorithm.api.SymmetricAlg;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.util.Checker;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public abstract class SymmetricKey {
    protected final SymmetricAlg alg;
    protected final byte[] value;

    protected SymmetricKey(SymmetricAlg alg, byte[] value) {
        this.alg = alg;
        this.value = value;
    }

    public static SymmetricKey newInstance(SymmetricAlg alg, int bits) {
        Checker.check(alg != null, "Illegal argument `alg`: alg must not be null.", new Object[0]);
        Checker.check(bits % 8 == 0, "The value of bits must be a multiple of 8.", new Object[0]);
        if (alg == SymmetricAlg.DES) {
            Checker.check(bits == 64 || bits == 128 || bits == 192, "Illegal argument 'bits':3DES algorithm key length must be 64 bits or 128 bits or 192 bits.", new Object[0]);
        }
        if (alg == SymmetricAlg.AES) {
            Checker.check(bits == 256 || bits == 128 || bits == 192, "Illegal argument 'bits':AES algorithm key length must be 128 bits or 192 bits or 256 bits.", new Object[0]);
        }
        if (alg == SymmetricAlg.SM4) {
            Checker.check(bits == 128, "Illegal argument 'bits':SM4 algorithm key length must be 128 bits.", new Object[0]);
        }
        byte[] bytes = new byte[bits / 8];
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.nextBytes(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AlgorithmCallingException("Generate random key failed.", e);
        }
        return SymmetricKey.newInstance(alg, bytes);
    }

    public static SymmetricKey newInstance(SymmetricAlg alg, byte[] value) {
        Checker.check(alg != null, "Illegal argument `alg`: alg must not be null.", new Object[0]);
        switch (alg) {
            case SM4: {
                Checker.check(value != null && value.length == 16, "Illegal argument: SM4 algorithm key length must be 128 bits.", new Object[0]);
                return new SM4SymmetricKey(alg, value);
            }
            case AES: {
                return new AESSymmetricKey(alg, value);
            }
            case DES: {
                Checker.check(value != null, "Illegal argument: the key for 3DES algorithm can not be null.", new Object[0]);
                return new DESedeSymmetricKey(alg, value);
            }
        }
        throw new AlgorithmCallingException("Can not support algorithm %s.", alg.name());
    }

    public abstract byte[] encryptECB(byte[] var1, Padding var2);

    public abstract byte[] decryptECB(byte[] var1, Padding var2);

    public abstract byte[] encryptCBC(byte[] var1, byte[] var2, Padding var3);

    public abstract byte[] decryptCBC(byte[] var1, byte[] var2, Padding var3);

    public abstract byte[] encryptOFB(byte[] var1, byte[] var2, Padding var3);

    public abstract byte[] decryptOFB(byte[] var1, byte[] var2, Padding var3);

    public abstract byte[] encryptCFB(byte[] var1, byte[] var2, Padding var3);

    public abstract byte[] decryptCFB(byte[] var1, byte[] var2, Padding var3);

    public abstract byte[] encryptCTR(byte[] var1, byte[] var2, Padding var3);

    public abstract byte[] decryptCTR(byte[] var1, byte[] var2, Padding var3);

    public abstract byte[] encryptCTR(byte[] var1, Padding var2);

    public abstract byte[] decryptCTR(byte[] var1, Padding var2);

    public abstract byte[] encryptGCM(byte[] var1, byte[] var2, byte[] var3);

    public abstract byte[] decryptGCM(byte[] var1, byte[] var2, byte[] var3);

    public abstract byte[] encryptGCM(byte[] var1, byte[] var2);

    public abstract byte[] decryptGCM(byte[] var1, byte[] var2);

    public SymmetricAlg getAlg() {
        return this.alg;
    }

    public byte[] getValue() {
        return this.value;
    }
}

