/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api;

import io.soft.algorithm.api.Padding;
import io.soft.algorithm.api.SymmetricAlg;
import io.soft.algorithm.api.SymmetricKey;
import io.soft.algorithm.api.v1.Algorithm;
import io.soft.algorithm.api.v1.Cipher;
import io.soft.algorithm.api.v1.Mode;
import io.soft.algorithm.util.Checker;

final class SM4SymmetricKey
extends SymmetricKey {
    public SM4SymmetricKey(SymmetricAlg alg, byte[] value) {
        super(alg, value);
    }

    public byte[] encryptECB(byte[] data, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.SM4, Mode.ECB, padding);
        return cipher.encrypt(this.value, data);
    }

    public byte[] decryptECB(byte[] data, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.SM4, Mode.ECB, padding);
        return cipher.decrypt(this.value, data);
    }

    public byte[] encryptCBC(byte[] data, byte[] iv, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.SM4, Mode.CBC, padding);
        cipher.setIv(iv);
        return cipher.encrypt(this.value, data);
    }

    public byte[] decryptCBC(byte[] data, byte[] iv, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.SM4, Mode.CBC, padding);
        cipher.setIv(iv);
        return cipher.decrypt(this.value, data);
    }

    public byte[] encryptOFB(byte[] data, byte[] iv, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.SM4, Mode.OFB, padding);
        cipher.setIv(iv);
        return cipher.encrypt(this.value, data);
    }

    public byte[] decryptOFB(byte[] data, byte[] iv, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.SM4, Mode.OFB, padding);
        cipher.setIv(iv);
        return cipher.decrypt(this.value, data);
    }

    public byte[] encryptCFB(byte[] data, byte[] iv, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.SM4, Mode.CFB, padding);
        cipher.setIv(iv);
        return cipher.encrypt(this.value, data);
    }

    public byte[] decryptCFB(byte[] data, byte[] iv, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.SM4, Mode.CFB, padding);
        cipher.setIv(iv);
        return cipher.decrypt(this.value, data);
    }

    public byte[] encryptCTR(byte[] data, byte[] iv, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.SM4, Mode.CTR, padding);
        cipher.setIv(iv);
        return cipher.encrypt(this.value, data);
    }

    public byte[] decryptCTR(byte[] data, byte[] iv, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.SM4, Mode.CTR, padding);
        cipher.setIv(iv);
        return cipher.decrypt(this.value, data);
    }

    public byte[] encryptCTR(byte[] data, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.SM4, Mode.CTR, padding);
        cipher.setIv(new byte[16]);
        return cipher.encrypt(this.value, data);
    }

    public byte[] decryptCTR(byte[] data, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.SM4, Mode.CTR, padding);
        cipher.setIv(new byte[16]);
        return cipher.decrypt(this.value, data);
    }

    public byte[] encryptGCM(byte[] data, byte[] iv, byte[] aad) {
        Cipher cipher = Cipher.getInstance(Algorithm.SM4, Mode.GCM, Padding.NoPadding);
        cipher.setIv(iv);
        cipher.setAad(aad);
        return cipher.encrypt(this.value, data);
    }

    public byte[] decryptGCM(byte[] data, byte[] iv, byte[] aad) {
        Cipher cipher = Cipher.getInstance(Algorithm.SM4, Mode.GCM, Padding.NoPadding);
        cipher.setIv(iv);
        cipher.setAad(aad);
        return cipher.decrypt(this.value, data);
    }

    public byte[] encryptGCM(byte[] data, byte[] iv) {
        Cipher cipher = Cipher.getInstance(Algorithm.SM4, Mode.GCM, Padding.NoPadding);
        cipher.setIv(iv);
        return cipher.encrypt(this.value, data);
    }

    public byte[] decryptGCM(byte[] data, byte[] iv) {
        Cipher cipher = Cipher.getInstance(Algorithm.SM4, Mode.GCM, Padding.NoPadding);
        cipher.setIv(iv);
        return cipher.decrypt(this.value, data);
    }
}

