/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api;

import io.soft.algorithm.api.Padding;
import io.soft.algorithm.api.v1.Algorithm;
import io.soft.algorithm.api.v1.Cipher;
import io.soft.algorithm.api.v1.KeyAgreement;
import io.soft.algorithm.api.v1.KeyPair;
import io.soft.algorithm.api.v1.KeyPairGenerator;
import io.soft.algorithm.api.v1.Mode;
import io.soft.algorithm.api.v1.Signature;
import io.soft.algorithm.asn1.ASN1EncodableVector;
import io.soft.algorithm.asn1.ASN1InputStream;
import io.soft.algorithm.asn1.ASN1Integer;
import io.soft.algorithm.asn1.ASN1Sequence;
import io.soft.algorithm.asn1.DERSequence;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.util.Checker;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;

public final class SM2 {
    private static final byte[] DEFAULT_USER_ID = "1234567812345678".getBytes();
    private final byte[] publicKey;
    private final byte[] privateKey;

    private SM2(byte[] publicKey, byte[] privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public static SM2 newInstance() {
        KeyPairGenerator sm2 = KeyPairGenerator.getSM2();
        KeyPair pair = sm2.generator();
        return new SM2(pair.getPublicKey(), pair.getPrivateKey());
    }

    public static SM2 newInstance(byte[] publicKey, byte[] privateKey) {
        if (publicKey != null && publicKey.length == 65 && publicKey[0] == 4) {
            byte[] bytes = new byte[64];
            System.arraycopy(publicKey, 1, bytes, 0, 64);
            return new SM2(bytes, privateKey);
        }
        return new SM2(publicKey, privateKey);
    }

    public byte[] sign(byte[] data) {
        Signature instance = Signature.getInstance(Algorithm.SM2, Algorithm.NONE);
        instance.setUserID(DEFAULT_USER_ID);
        return instance.sign(this.privateKey, data);
    }

    public byte[] sign(byte[] data, byte[] userId) {
        Signature instance = Signature.getInstance(Algorithm.SM2, Algorithm.NONE);
        instance.setUserID(userId);
        return instance.sign(this.privateKey, data);
    }

    public boolean verify(byte[] sign, byte[] data) {
        Signature instance = Signature.getInstance(Algorithm.SM2, Algorithm.NONE);
        instance.setUserID(DEFAULT_USER_ID);
        return instance.verify(this.publicKey, data, sign);
    }

    public boolean verify(byte[] sign, byte[] data, byte[] userId) {
        Signature instance = Signature.getInstance(Algorithm.SM2, Algorithm.NONE);
        instance.setUserID(userId);
        return instance.verify(this.publicKey, data, sign);
    }

    public byte[] signWithDer(byte[] data) {
        Signature instance = Signature.getInstance(Algorithm.SM2, Algorithm.NONE);
        instance.setUserID(DEFAULT_USER_ID);
        return this.encodeDERSignature(instance.sign(this.privateKey, data));
    }

    public byte[] signWithDer(byte[] data, byte[] userId) {
        Signature instance = Signature.getInstance(Algorithm.SM2, Algorithm.NONE);
        instance.setUserID(userId);
        return this.encodeDERSignature(instance.sign(this.privateKey, data));
    }

    public boolean verifyWithDer(byte[] sign, byte[] data) {
        Signature instance = Signature.getInstance(Algorithm.SM2, Algorithm.NONE);
        instance.setUserID(DEFAULT_USER_ID);
        return instance.verify(this.publicKey, data, this.decodeDERSignature(sign));
    }

    public boolean verifyWithDer(byte[] sign, byte[] data, byte[] userId) {
        Signature instance = Signature.getInstance(Algorithm.SM2, Algorithm.NONE);
        instance.setUserID(userId);
        return instance.verify(this.publicKey, data, this.decodeDERSignature(sign));
    }

    public byte[] encrypt(byte[] data) {
        Cipher cipher = Cipher.getInstance(Algorithm.SM2, Mode.NONE, Padding.NoPadding);
        return cipher.encrypt(this.publicKey, data);
    }

    public byte[] decrypt(byte[] data) {
        Cipher cipher = Cipher.getInstance(Algorithm.SM2, Mode.NONE, Padding.NoPadding);
        return cipher.decrypt(this.privateKey, data);
    }

    public byte[] encryptWithC1C2C3(byte[] data) {
        Cipher cipher = Cipher.getInstance(Algorithm.SM2, Mode.NONE, Padding.NoPadding);
        return this.C1C3C2ToC1C2C3(cipher.encrypt(this.publicKey, data));
    }

    public byte[] decryptWithC1C2C3(byte[] data) {
        Cipher cipher = Cipher.getInstance(Algorithm.SM2, Mode.NONE, Padding.NoPadding);
        return cipher.decrypt(this.privateKey, this.C1C2C3ToC1C3C2(data));
    }

    public byte[] keyExchange(boolean organizer, SM2 tempPrivateKey, SM2 otherPublicKey, SM2 otherTempPublicKey, byte[] userId, byte[] otherUserId, int keySize) {
        Checker.check(tempPrivateKey != null, "the temporary private key for sm2 key agreement can not be null.", new Object[0]);
        Checker.check(otherPublicKey != null, "the static public key of other user can not be null.", new Object[0]);
        Checker.check(otherTempPublicKey != null, "the temporary public key of other user can not be null.", new Object[0]);
        return KeyAgreement.SM2KeyExchange(organizer, this.privateKey, tempPrivateKey.getPrivateKey(), otherPublicKey.getPublicKey(), otherTempPublicKey.getPublicKey(), userId, otherUserId, keySize);
    }

    public byte[] keyExchange(boolean organizer, SM2 tempPrivateKey, SM2 otherPublicKey, SM2 otherTempPublicKey, int keySize) {
        Checker.check(tempPrivateKey != null, "the temporary private key for sm2 key agreement can not be null.", new Object[0]);
        Checker.check(otherPublicKey != null, "the static public key of other user can not be null.", new Object[0]);
        Checker.check(otherTempPublicKey != null, "the temporary public key of other user can not be null.", new Object[0]);
        return KeyAgreement.SM2KeyExchange(organizer, this.privateKey, tempPrivateKey.getPrivateKey(), otherPublicKey.getPublicKey(), otherTempPublicKey.getPublicKey(), DEFAULT_USER_ID, DEFAULT_USER_ID, keySize);
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    private byte[] C1C2C3ToC1C3C2(byte[] cipherText) throws AlgorithmCallingException {
        if (cipherText == null || cipherText.length < 96) {
            throw new AlgorithmCallingException("Illegal cipherText, the size must be more than 95 bytes.");
        }
        byte[] bytes = new byte[cipherText.length];
        System.arraycopy(cipherText, 0, bytes, 0, 64);
        System.arraycopy(cipherText, cipherText.length - 32, bytes, 64, 32);
        System.arraycopy(cipherText, 64, bytes, 96, cipherText.length - 96);
        return bytes;
    }

    private byte[] C1C3C2ToC1C2C3(byte[] cipherText) throws AlgorithmCallingException {
        if (cipherText == null || cipherText.length < 96) {
            throw new AlgorithmCallingException("Illegal cipherText, the size must be more than 96 bytes.");
        }
        byte[] bytes = new byte[cipherText.length];
        System.arraycopy(cipherText, 0, bytes, 0, 64);
        System.arraycopy(cipherText, 96, bytes, 64, cipherText.length - 96);
        System.arraycopy(cipherText, 64, bytes, cipherText.length - 32, 32);
        return bytes;
    }

    private byte[] encodeDERSignature(byte[] signature) throws AlgorithmCallingException {
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        System.arraycopy(signature, 0, r, 0, 32);
        System.arraycopy(signature, 32, s, 0, 32);
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(new ASN1Integer(new BigInteger(1, r)));
        vector.add(new ASN1Integer(new BigInteger(1, s)));
        try {
            return new DERSequence(vector).getEncoded();
        }
        catch (IOException e) {
            throw new AlgorithmCallingException("Encode DER signature failed.", e);
        }
    }

    private byte[] decodeDERSignature(byte[] signature) throws AlgorithmCallingException {
        Checker.check(signature != null, "the sign of sm2 signature verify can not be null.", new Object[0]);
        ASN1InputStream stream = new ASN1InputStream(new ByteArrayInputStream(signature));
        try {
            ASN1Sequence primitive = (ASN1Sequence)stream.readObject();
            Enumeration enumeration = primitive.getObjects();
            BigInteger R = ((ASN1Integer)enumeration.nextElement()).getValue();
            BigInteger S = ((ASN1Integer)enumeration.nextElement()).getValue();
            byte[] bytes = new byte[64];
            byte[] r = this.format(R.toByteArray());
            byte[] s = this.format(S.toByteArray());
            System.arraycopy(r, 0, bytes, 0, 32);
            System.arraycopy(s, 0, bytes, 32, 32);
            return bytes;
        }
        catch (Exception e) {
            throw new AlgorithmCallingException("Parse DER signature failed.", e);
        }
    }

    private byte[] format(byte[] value) {
        if (value.length == 32) {
            return value;
        }
        byte[] bytes = new byte[32];
        if (value.length > 32) {
            System.arraycopy(value, value.length - 32, bytes, 0, 32);
        } else {
            System.arraycopy(value, 0, bytes, 32 - value.length, value.length);
        }
        return bytes;
    }
}

