/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api;

import io.soft.algorithm.api.DigestAlg;
import io.soft.algorithm.api.RSAPadding;
import io.soft.algorithm.api.v1.Algorithm;
import io.soft.algorithm.api.v1.Cipher;
import io.soft.algorithm.api.v1.KeyPair;
import io.soft.algorithm.api.v1.KeyPairGenerator;
import io.soft.algorithm.api.v1.Mode;
import io.soft.algorithm.api.v1.Signature;
import io.soft.algorithm.util.Checker;

public class RSA {
    private final byte[] publicKey;
    private final byte[] privateKey;

    private RSA(byte[] publicKey, byte[] privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    public static RSA newInstance(int bits, int publicExponent) {
        KeyPairGenerator generator = KeyPairGenerator.getRSA(bits, publicExponent);
        KeyPair pair = generator.generator();
        return RSA.newInstance(pair.getPublicKey(), pair.getPrivateKey());
    }

    public static RSA newInstance(byte[] publicKey, byte[] privateKey) {
        return new RSA(publicKey, privateKey);
    }

    public byte[] sign(byte[] data) {
        Signature signature = Signature.getInstance(Algorithm.RSA, Algorithm.NONE);
        return signature.sign(this.privateKey, data);
    }

    public boolean verify(byte[] sign, byte[] data) {
        Signature signature = Signature.getInstance(Algorithm.RSA, Algorithm.NONE);
        return signature.verify(this.publicKey, data, sign);
    }

    public byte[] sign(byte[] data, DigestAlg digest) {
        Checker.check(digest != null, "Illegal argument `digest`: digest must not be null.", new Object[0]);
        Signature signature = Signature.getInstance(Algorithm.RSA, Algorithm.valueOf(digest.name()));
        return signature.sign(this.privateKey, data);
    }

    public boolean verify(byte[] sign, byte[] data, DigestAlg digest) {
        Checker.check(digest != null, "Illegal argument `digest`: digest must not be null.", new Object[0]);
        Signature signature = Signature.getInstance(Algorithm.RSA, Algorithm.valueOf(digest.name()));
        return signature.verify(this.publicKey, data, sign);
    }

    public byte[] encrypt(byte[] data, RSAPadding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.RSA, Mode.NONE, padding);
        return cipher.encrypt(this.publicKey, data);
    }

    public byte[] decrypt(byte[] data, RSAPadding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.RSA, Mode.NONE, padding);
        return cipher.decrypt(this.privateKey, data);
    }
}

