/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api;

import io.soft.algorithm.api.Padding;
import io.soft.algorithm.api.RSA;
import io.soft.algorithm.api.RSAPadding;
import io.soft.algorithm.api.SM2;
import io.soft.algorithm.api.SymmetricAlg;
import io.soft.algorithm.api.SymmetricKey;
import io.soft.algorithm.api.v1.Algorithm;
import io.soft.algorithm.api.v1.Cipher;
import io.soft.algorithm.api.v1.Mode;
import io.soft.algorithm.util.Hex;

public class DigitalEnvelope {
    private static byte[] publicKey;
    private static byte[] privateKey;
    private static Cipher cipher;
    private static SymmetricAlg symmetricAlg;
    private static int keySize;

    private DigitalEnvelope(SymmetricAlg alg, int bits, byte[] pk, byte[] vk, Cipher cipher) {
        DigitalEnvelope.cipher = cipher;
        publicKey = pk;
        privateKey = vk;
        keySize = bits;
        symmetricAlg = alg;
    }

    public static DigitalEnvelope newInstance(SM2 sm2, SymmetricAlg alg, int bits) {
        Cipher cipher = Cipher.getInstance(Algorithm.SM2, Mode.NONE, Padding.NoPadding);
        return new DigitalEnvelope(alg, bits, sm2.getPublicKey(), sm2.getPrivateKey(), cipher);
    }

    public static DigitalEnvelope newInstance(RSA rsa, RSAPadding rsaPadding, SymmetricAlg alg, int bits) {
        Cipher cipher = Cipher.getInstance(Algorithm.RSA, Mode.NONE, rsaPadding);
        return new DigitalEnvelope(alg, bits, rsa.getPublicKey(), rsa.getPrivateKey(), cipher);
    }

    public Envelope encryptECB(byte[] data, Padding padding) {
        SymmetricKey symmetricKey = SymmetricKey.newInstance(symmetricAlg, keySize);
        byte[] keyCipher = cipher.encrypt(publicKey, symmetricKey.getValue());
        return new Envelope(Hex.encode(keyCipher), Hex.encode(symmetricKey.encryptECB(data, padding)));
    }

    public byte[] decryptECB(Envelope data, Padding padding) {
        String keyCipher = data.getEncryptedKey();
        String dataCipher = data.getEncryptedData();
        byte[] key = cipher.decrypt(privateKey, Hex.decode(keyCipher));
        SymmetricKey symmetricKey = SymmetricKey.newInstance(symmetricAlg, key);
        return symmetricKey.decryptECB(Hex.decode(dataCipher), padding);
    }

    public Envelope encryptCBC(byte[] data, byte[] iv, Padding padding) {
        SymmetricKey symmetricKey = SymmetricKey.newInstance(symmetricAlg, keySize);
        byte[] keyCipher = cipher.encrypt(publicKey, symmetricKey.getValue());
        return new Envelope(Hex.encode(keyCipher), Hex.encode(symmetricKey.encryptCBC(data, iv, padding)));
    }

    public byte[] decryptCBC(Envelope data, byte[] iv, Padding padding) {
        String keyCipher = data.getEncryptedKey();
        String dataCipher = data.getEncryptedData();
        byte[] key = cipher.decrypt(privateKey, Hex.decode(keyCipher));
        SymmetricKey symmetricKey = SymmetricKey.newInstance(symmetricAlg, key);
        return symmetricKey.decryptCBC(Hex.decode(dataCipher), iv, padding);
    }

    public Envelope encryptCFB(byte[] data, byte[] iv, Padding padding) {
        SymmetricKey symmetricKey = SymmetricKey.newInstance(symmetricAlg, keySize);
        byte[] keyCipher = cipher.encrypt(publicKey, symmetricKey.getValue());
        return new Envelope(Hex.encode(keyCipher), Hex.encode(symmetricKey.encryptCFB(data, iv, padding)));
    }

    public byte[] decryptCFB(Envelope data, byte[] iv, Padding padding) {
        String keyCipher = data.getEncryptedKey();
        String dataCipher = data.getEncryptedData();
        byte[] key = cipher.decrypt(privateKey, Hex.decode(keyCipher));
        SymmetricKey symmetricKey = SymmetricKey.newInstance(symmetricAlg, key);
        return symmetricKey.decryptCFB(Hex.decode(dataCipher), iv, padding);
    }

    public Envelope encryptOFB(byte[] data, byte[] iv, Padding padding) {
        SymmetricKey symmetricKey = SymmetricKey.newInstance(symmetricAlg, keySize);
        byte[] keyCipher = cipher.encrypt(publicKey, symmetricKey.getValue());
        return new Envelope(Hex.encode(keyCipher), Hex.encode(symmetricKey.encryptOFB(data, iv, padding)));
    }

    public byte[] decryptOFB(Envelope data, byte[] iv, Padding padding) {
        String keyCipher = data.getEncryptedKey();
        String dataCipher = data.getEncryptedData();
        byte[] key = cipher.decrypt(privateKey, Hex.decode(keyCipher));
        SymmetricKey symmetricKey = SymmetricKey.newInstance(symmetricAlg, key);
        return symmetricKey.decryptOFB(Hex.decode(dataCipher), iv, padding);
    }

    public Envelope encryptCTR(byte[] data, byte[] iv, Padding padding) {
        SymmetricKey symmetricKey = SymmetricKey.newInstance(symmetricAlg, keySize);
        byte[] keyCipher = cipher.encrypt(publicKey, symmetricKey.getValue());
        return new Envelope(Hex.encode(keyCipher), Hex.encode(symmetricKey.encryptCTR(data, iv, padding)));
    }

    public byte[] decryptCTR(Envelope data, byte[] iv, Padding padding) {
        String keyCipher = data.getEncryptedKey();
        String dataCipher = data.getEncryptedData();
        byte[] key = cipher.decrypt(privateKey, Hex.decode(keyCipher));
        SymmetricKey symmetricKey = SymmetricKey.newInstance(symmetricAlg, key);
        return symmetricKey.decryptCTR(Hex.decode(dataCipher), iv, padding);
    }

    public Envelope encryptCTR(byte[] data, Padding padding) {
        SymmetricKey symmetricKey = SymmetricKey.newInstance(symmetricAlg, keySize);
        byte[] keyCipher = cipher.encrypt(publicKey, symmetricKey.getValue());
        return new Envelope(Hex.encode(keyCipher), Hex.encode(symmetricKey.encryptCTR(data, padding)));
    }

    public byte[] decryptCTR(Envelope data, Padding padding) {
        String keyCipher = data.getEncryptedKey();
        String dataCipher = data.getEncryptedData();
        byte[] key = cipher.decrypt(privateKey, Hex.decode(keyCipher));
        SymmetricKey symmetricKey = SymmetricKey.newInstance(symmetricAlg, key);
        return symmetricKey.decryptCTR(Hex.decode(dataCipher), padding);
    }

    public Envelope encryptGCM(byte[] data, byte[] iv, byte[] aad) {
        SymmetricKey symmetricKey = SymmetricKey.newInstance(symmetricAlg, keySize);
        byte[] keyCipher = cipher.encrypt(publicKey, symmetricKey.getValue());
        return new Envelope(Hex.encode(keyCipher), Hex.encode(symmetricKey.encryptGCM(data, iv, aad)));
    }

    public byte[] decryptGCM(Envelope data, byte[] iv, byte[] aad) {
        String keyCipher = data.getEncryptedKey();
        String dataCipher = data.getEncryptedData();
        byte[] key = cipher.decrypt(privateKey, Hex.decode(keyCipher));
        SymmetricKey symmetricKey = SymmetricKey.newInstance(symmetricAlg, key);
        return symmetricKey.decryptGCM(Hex.decode(dataCipher), iv, aad);
    }

    public Envelope encryptGCM(byte[] data, byte[] iv) {
        SymmetricKey symmetricKey = SymmetricKey.newInstance(symmetricAlg, keySize);
        byte[] keyCipher = cipher.encrypt(publicKey, symmetricKey.getValue());
        return new Envelope(Hex.encode(keyCipher), Hex.encode(symmetricKey.encryptGCM(data, iv)));
    }

    public byte[] decryptGCM(Envelope data, byte[] iv) {
        String keyCipher = data.getEncryptedKey();
        String dataCipher = data.getEncryptedData();
        byte[] key = cipher.decrypt(privateKey, Hex.decode(keyCipher));
        SymmetricKey symmetricKey = SymmetricKey.newInstance(symmetricAlg, key);
        return symmetricKey.decryptGCM(Hex.decode(dataCipher), iv);
    }

    public static class Envelope {
        private final String encryptedKey;
        private final String encryptedData;

        public Envelope(String encryptedKey, String encryptedData) {
            this.encryptedKey = encryptedKey;
            this.encryptedData = encryptedData;
        }

        public String getEncryptedKey() {
            return this.encryptedKey;
        }

        public String getEncryptedData() {
            return this.encryptedData;
        }
    }
}

