/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api;

import io.soft.algorithm.api.DigestAlg;
import io.soft.algorithm.api.v1.Algorithm;
import io.soft.algorithm.api.v1.MAC;
import io.soft.algorithm.api.v1.MessageDigest;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.util.Checker;

public final class Digest {
    public static byte[] digest(byte[] data, DigestAlg alg) {
        Checker.check(alg != null, "Illegal argument `alg`: alg must not be null.", new Object[0]);
        switch (alg) {
            case MD5: {
                return MessageDigest.getInstance(Algorithm.MD5).digest(data);
            }
            case SHA1: {
                return MessageDigest.getInstance(Algorithm.SHA1).digest(data);
            }
            case SM3: {
                return MessageDigest.getInstance(Algorithm.SM3).digest(data);
            }
            case SHA224: {
                return MessageDigest.getInstance(Algorithm.SHA224).digest(data);
            }
            case SHA256: {
                return MessageDigest.getInstance(Algorithm.SHA256).digest(data);
            }
            case SHA384: {
                return MessageDigest.getInstance(Algorithm.SHA384).digest(data);
            }
            case SHA512: {
                return MessageDigest.getInstance(Algorithm.SHA512).digest(data);
            }
        }
        throw new AlgorithmCallingException("Can not support digest algorithm %s.", alg.name());
    }

    public static byte[] hmac(byte[] key, byte[] data, DigestAlg alg) {
        Checker.check(alg != null, "Illegal argument `alg`: alg must not be null.", new Object[0]);
        switch (alg) {
            case MD5: {
                return MAC.getInstance(Algorithm.MD5).mac(key, data);
            }
            case SHA1: {
                return MAC.getInstance(Algorithm.SHA1).mac(key, data);
            }
            case SM3: {
                return MAC.getInstance(Algorithm.SM3).mac(key, data);
            }
            case SHA224: {
                return MAC.getInstance(Algorithm.SHA224).mac(key, data);
            }
            case SHA256: {
                return MAC.getInstance(Algorithm.SHA256).mac(key, data);
            }
            case SHA384: {
                return MAC.getInstance(Algorithm.SHA384).mac(key, data);
            }
            case SHA512: {
                return MAC.getInstance(Algorithm.SHA512).mac(key, data);
            }
        }
        throw new AlgorithmCallingException("Can not support HMAC algorithm %s.", alg.name());
    }
}

