/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.api;

import io.soft.algorithm.api.Padding;
import io.soft.algorithm.api.SymmetricAlg;
import io.soft.algorithm.api.SymmetricKey;
import io.soft.algorithm.api.v1.Algorithm;
import io.soft.algorithm.api.v1.Cipher;
import io.soft.algorithm.api.v1.Mode;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.util.Checker;

public class DESedeSymmetricKey
extends SymmetricKey {
    public DESedeSymmetricKey(SymmetricAlg alg, byte[] value) {
        super(alg, value);
    }

    public byte[] encryptECB(byte[] data, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.DESede, Mode.ECB, padding);
        return cipher.encrypt(this.value, data);
    }

    public byte[] decryptECB(byte[] data, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.DESede, Mode.ECB, padding);
        return cipher.decrypt(this.value, data);
    }

    public byte[] encryptCBC(byte[] data, byte[] iv, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.DESede, Mode.CBC, padding);
        cipher.setIv(iv);
        return cipher.encrypt(this.value, data);
    }

    public byte[] decryptCBC(byte[] data, byte[] iv, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.DESede, Mode.CBC, padding);
        cipher.setIv(iv);
        return cipher.decrypt(this.value, data);
    }

    public byte[] encryptOFB(byte[] data, byte[] iv, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.DESede, Mode.OFB, padding);
        cipher.setIv(iv);
        return cipher.encrypt(this.value, data);
    }

    public byte[] decryptOFB(byte[] data, byte[] iv, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.DESede, Mode.OFB, padding);
        cipher.setIv(iv);
        return cipher.decrypt(this.value, data);
    }

    public byte[] encryptCFB(byte[] data, byte[] iv, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.DESede, Mode.CFB, padding);
        cipher.setIv(iv);
        return cipher.encrypt(this.value, data);
    }

    public byte[] decryptCFB(byte[] data, byte[] iv, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.DESede, Mode.CFB, padding);
        cipher.setIv(iv);
        return cipher.decrypt(this.value, data);
    }

    public byte[] encryptCTR(byte[] data, byte[] iv, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.DESede, Mode.CTR, padding);
        cipher.setIv(iv);
        return cipher.encrypt(this.value, data);
    }

    public byte[] decryptCTR(byte[] data, byte[] iv, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.DESede, Mode.CTR, padding);
        cipher.setIv(iv);
        return cipher.decrypt(this.value, data);
    }

    public byte[] encryptCTR(byte[] data, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.DESede, Mode.CTR, padding);
        cipher.setIv(new byte[8]);
        return cipher.encrypt(this.value, data);
    }

    public byte[] decryptCTR(byte[] data, Padding padding) {
        Checker.check(padding != null, "Illegal argument `padding`: padding must not be null.", new Object[0]);
        Cipher cipher = Cipher.getInstance(Algorithm.DESede, Mode.CTR, padding);
        cipher.setIv(new byte[8]);
        return cipher.decrypt(this.value, data);
    }

    public byte[] encryptGCM(byte[] data, byte[] iv, byte[] aad) {
        throw new AlgorithmCallingException("3DES algorithm does not support GCM mode.");
    }

    public byte[] decryptGCM(byte[] data, byte[] iv, byte[] aad) {
        throw new AlgorithmCallingException("3DES algorithm does not support GCM mode.");
    }

    public byte[] encryptGCM(byte[] data, byte[] iv) {
        throw new AlgorithmCallingException("3DES algorithm does not support GCM mode.");
    }

    public byte[] decryptGCM(byte[] data, byte[] iv) {
        throw new AlgorithmCallingException("3DES algorithm does not support GCM mode.");
    }
}

