/*
 * Decompiled with CFR 0.152.
 */
package com.scrcu.opensdk.util;

import com.scrcu.opensdk.exception.ScrcuApiException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SensitiveInfoUtil {
    private static final int[] power = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static final String[] refNumber = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3"};
    private static final String[] provinceCode = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    private static final String regularExpression = "(^[1-9]\\d{5}(18|19|20)\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}$)";

    public static String sensitive(String data, String rule) throws ScrcuApiException {
        if (rule == null) {
            throw new ScrcuApiException("OP00012009", "\u5f53\u524d\u8131\u654f\u89c4\u5219[" + rule + "]\u4e0d\u5b58\u5728");
        }
        if (rule.equals("phone")) {
            return SensitiveInfoUtil.mobileEncrypt(data);
        }
        if (rule.equals("cnName")) {
            return SensitiveInfoUtil.cnNameCkeck(data);
        }
        if (rule.equals("enName")) {
            return SensitiveInfoUtil.enNameCkeck(data);
        }
        if (rule.equals("idNumber")) {
            return SensitiveInfoUtil.idCkeck(data);
        }
        throw new ScrcuApiException("OP00012009", "\u5f53\u524d\u8131\u654f\u89c4\u5219[" + rule + "]\u4e0d\u5b58\u5728");
    }

    private static boolean isPhone(String phone) throws ScrcuApiException {
        String regex = "^((13[0-9])|(14[5|7])|(15([0-3]|[5-9]))|(17[013678])|(18[0,5-9]))\\d{8}$";
        if (phone.length() != 11) {
            throw new ScrcuApiException("OP00011008", "\u5f53\u524d\u8131\u654f\u624b\u673a\u53f7[" + phone + "]\u683c\u5f0f\u4e0d\u89c4\u8303");
        }
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(phone);
        boolean isMatch = m.matches();
        return isMatch;
    }

    private static String mobileEncrypt(String mobile) throws ScrcuApiException {
        if (SensitiveInfoUtil.isPhone(mobile)) {
            return mobile.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
        }
        throw new ScrcuApiException("OP00011008", "\u5f53\u524d\u8131\u654f\u624b\u673a\u53f7[" + mobile + "]\u683c\u5f0f\u4e0d\u89c4\u8303");
    }

    private static String idCkeck(String id) throws ScrcuApiException {
        SensitiveInfoUtil.isNumber(id);
        SensitiveInfoUtil.checkProvinceId(id.substring(0, 2));
        SensitiveInfoUtil.isValidDate(id.substring(6, 14));
        SensitiveInfoUtil.checkCardIdLastNum(id);
        boolean matches = id.matches(regularExpression);
        if (matches) {
            return id.replaceAll("(\\d{3})\\d{11}(\\d{4})", "$1***********$2");
        }
        throw new ScrcuApiException("OP00011009", "\u5f53\u524d\u8131\u654f\u8eab\u4efd\u8bc1[" + id + "]\u683c\u5f0f\u4e0d\u89c4\u8303");
    }

    private static String cnNameCkeck(String cnName) throws ScrcuApiException {
        SensitiveInfoUtil.isChineseName(cnName);
        return SensitiveInfoUtil.desensitizationByRealName(cnName);
    }

    private static String enNameCkeck(String enName) throws ScrcuApiException {
        SensitiveInfoUtil.isEnName(enName);
        return SensitiveInfoUtil.desensitizationByRealEnName(enName);
    }

    private static String desensitizationByRealName(String realName) {
        if (realName.length() == 1) {
            return realName.replaceAll("\\D{2}(\\D{1})", "**$1");
        }
        int length = realName.length() - 1;
        String flag = "*";
        String num = "";
        int i = 0;
        while (i < length) {
            num = String.valueOf(num) + flag;
            ++i;
        }
        return realName.replaceAll("\\D{" + length + "}(\\D{1})", String.valueOf(num) + "$1");
    }

    private static String desensitizationByRealEnName(String realName) throws ScrcuApiException {
        if (realName.length() <= 4) {
            return realName;
        }
        int length = realName.length() - 4;
        String flag = "*";
        String num = "";
        int i = 0;
        while (i < length) {
            num = String.valueOf(num) + flag;
            ++i;
        }
        return realName.replaceAll("(\\D{2})\\D{" + length + "}(\\D{2})", "$1" + num + "$2");
    }

    private static void isNumber(String id) throws ScrcuApiException {
        if (Pattern.matches("[^[0-9]+$]{18}", id)) {
            return;
        }
        throw new ScrcuApiException("OP00011009", "\u5f53\u524d\u8131\u654f\u8eab\u4efd\u8bc1[" + id + "]\u683c\u5f0f\u4e0d\u89c4\u8303");
    }

    private static void isEnName(String realname) throws ScrcuApiException {
        if (Pattern.matches("[^[a-zA-Z]+$]{1,30}", realname)) {
            return;
        }
        throw new ScrcuApiException("OP00011010", "\u5f53\u524d\u8131\u654f\u82f1\u6587\u540d[" + realname + "]\u683c\u5f0f\u4e0d\u89c4\u8303");
    }

    private static void isChineseName(String realname) throws ScrcuApiException {
        if (Pattern.matches("[\u4e00-\u9fa5|\u00b7]{2,15}", realname)) {
            return;
        }
        throw new ScrcuApiException("OP00011011", "\u5f53\u524d\u8131\u654f\u4e2d\u6587\u540d[" + realname + "]\u683c\u5f0f\u4e0d\u89c4\u8303");
    }

    private static void isCardId(String cardid) throws ScrcuApiException {
        if (Pattern.matches("^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([\\d|x|X]{1})$", cardid)) {
            return;
        }
        throw new ScrcuApiException("OP00011009", "\u5f53\u524d\u8131\u654f\u8eab\u4efd\u8bc1[" + cardid + "]\u683c\u5f0f\u4e0d\u89c4\u8303");
    }

    private static String[] randomArray(int length) {
        int index = 0;
        String temp = ",";
        int ii = 0;
        while (ii < 1000) {
            int i = 0;
            while (i < length) {
                index = (int)(Math.random() * 10.0);
                temp = String.valueOf(temp) + index;
                ++i;
            }
            temp = String.valueOf(temp) + ",";
            ++ii;
        }
        return temp.split(",");
    }

    private static void checkProvinceId(String provinceid) throws ScrcuApiException {
        String[] stringArray = provinceCode;
        int n = provinceCode.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id.equals(provinceid)) {
                return;
            }
            ++n2;
        }
        throw new ScrcuApiException("OP00011012", "\u5f53\u524d\u8131\u654f\u8eab\u4efd\u8bc1\u4e2d\u7701\u4efd\u4fe1\u606f[" + provinceid + "]\u683c\u5f0f\u4e0d\u89c4\u8303");
    }

    private static void checkCardIdLastNum(String cardId) throws ScrcuApiException {
        if (cardId.length() != 18) {
            throw new ScrcuApiException("OP00011009", "\u5f53\u524d\u8131\u654f\u8eab\u4efd\u8bc1[" + cardId + "]\u683c\u5f0f\u4e0d\u89c4\u8303");
        }
        char[] tmp = cardId.toCharArray();
        int[] cardidArray = new int[tmp.length - 1];
        int i = 0;
        i = 0;
        while (i < tmp.length - 1) {
            cardidArray[i] = Integer.parseInt(String.valueOf(tmp[i]));
            ++i;
        }
        String checkCode = SensitiveInfoUtil.sumPower(cardidArray);
        String lastNum = String.valueOf(tmp[tmp.length - 1]);
        if (lastNum.equals("x")) {
            lastNum = lastNum.toUpperCase();
        }
        if (!checkCode.equals(lastNum)) {
            throw new ScrcuApiException("OP00011013", "\u5f53\u524d\u8131\u654f\u8eab\u4efd\u8bc1\u7b2c18\u4f4d[" + lastNum + "]\u683c\u5f0f\u4e0d\u89c4\u8303");
        }
    }

    private static String sumPower(int[] cardidArray) throws ScrcuApiException {
        try {
            int result = 0;
            int i = 0;
            while (i < power.length) {
                result += power[i] * cardidArray[i];
                ++i;
            }
            return refNumber[result % 11];
        }
        catch (Exception e) {
            throw new ScrcuApiException("OP00011009", "\u5f53\u524d\u8131\u654f\u8eab\u4efd\u8bc1\u683c\u5f0f\u4e0d\u89c4\u8303");
        }
    }

    private static void isValidDate(String inDate) throws ScrcuApiException {
        if (inDate == null) {
            throw new ScrcuApiException("OP00011014", "\u5f53\u524d\u8131\u654f\u8eab\u4efd\u8bc1\u4e2d\u65e5\u671f[" + inDate + "]\u683c\u5f0f\u4e0d\u89c4\u8303");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        if (inDate.trim().length() != dateFormat.toPattern().length()) {
            throw new ScrcuApiException("OP00011014", "\u5f53\u524d\u8131\u654f\u8eab\u4efd\u8bc1\u4e2d\u65e5\u671f[" + inDate + "]\u683c\u5f0f\u4e0d\u89c4\u8303");
        }
        dateFormat.setLenient(false);
        try {
            dateFormat.parse(inDate.trim());
        }
        catch (ParseException e) {
            throw new ScrcuApiException("OP00011014", "\u5f53\u524d\u8131\u654f\u8eab\u4efd\u8bc1\u4e2d\u65e5\u671f[" + inDate + "]\u683c\u5f0f\u4e0d\u89c4\u8303");
        }
    }
}

