/*
 * Decompiled with CFR 0.152.
 */
package com.scrcu.opensdk.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.scrcu.opensdk.ScrcuRequest;
import com.scrcu.opensdk.ScrcuResponse;
import com.scrcu.opensdk.exception.ScrcuApiException;
import com.scrcu.opensdk.internal.CallBackRequestHeader;
import com.scrcu.opensdk.internal.RequestHeader;
import com.scrcu.opensdk.internal.ResponseHeader;
import io.soft.algorithm.api.Padding;
import io.soft.algorithm.api.SM2;
import io.soft.algorithm.api.SymmetricAlg;
import io.soft.algorithm.api.SymmetricKey;
import io.soft.algorithm.util.Hex;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScrcuUtil {
    private static Logger logger = LoggerFactory.getLogger(ScrcuUtil.class);

    public static Boolean checkUrl(String url) throws ScrcuApiException {
        if (url == null || "".equals(url)) {
            logger.error("errorCode:OP00011001;errorMsg:url\u8bbe\u7f6e\u9519\u8bef");
            throw new ScrcuApiException("OP00011001", "Url\u8bbe\u7f6e\u9519\u8bef\uff01");
        }
        String apiUrl = url.substring(url.lastIndexOf("/") + 1);
        String leftString = url.substring(0, url.lastIndexOf("/")).trim();
        String serviceString = leftString.substring(leftString.lastIndexOf("/") + 1);
        if (apiUrl.substring(0, 3).equals("OPC") && apiUrl.length() == 24) {
            return true;
        }
        logger.error("errorCode:OP00011002;errorMsg:url\u8bbe\u7f6e\u9519\u8bef");
        throw new ScrcuApiException("OP00011001", "Url\u8bbe\u7f6e\u9519\u8bef\uff01");
    }

    public static String requestTime() {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
    }

    public static String requestTimeDate() {
        return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
    }

    public static int requestId() {
        return (int)((Math.random() * 9.0 + 1.0) * 100.0);
    }

    public static String toUpperCaseFirstOne(String s) throws ScrcuApiException {
        if (s == null || s.length() == 0) {
            logger.error("errorCode:OP00013001;errorMsg:\u8bbe\u7f6e\u7684request\u53c2\u6570\u540d\u4e0d\u7b26\u5408\u89c4\u8303");
            throw new ScrcuApiException("OP00013001", "\u8bbe\u7f6e\u7684request\u53c2\u6570\u540d\u4e0d\u7b26\u5408\u89c4\u8303");
        }
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static ScrcuRequest createRequest(ScrcuRequest request, String appSecret, String appId, String version) throws ScrcuApiException {
        if (request.getHeader() != null) {
            if (appId == null || "".equals(appId)) {
                logger.error("errorCode:OP00011002;errorMsg:\u8bbe\u7f6e\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
                throw new ScrcuApiException("OP00011004", "\u8bbe\u7f6e\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (version == null || "".equals(version)) {
                request.getHeader().setVersion("1.0.0");
                request.getHeader().setAppId(appId);
                request.getHeader().setRequestTime(ScrcuUtil.requestTimeDate());
                request.getHeader().setRequestId(String.valueOf(ScrcuUtil.requestTime()) + appId + ScrcuUtil.requestId());
                request.getHeader().setAppSecret(appSecret);
                ScrcuRequest scrcuRequest = new ScrcuRequest(request.getBody(), request.getHeader());
                return scrcuRequest;
            }
            request.getHeader().setAppId(appId);
            request.getHeader().setVersion(version);
            request.getHeader().setRequestTime(ScrcuUtil.requestTimeDate());
            request.getHeader().setRequestId(String.valueOf(ScrcuUtil.requestTime()) + appId + ScrcuUtil.requestId());
            request.getHeader().setAppSecret(appSecret);
            ScrcuRequest scrcuRequest = new ScrcuRequest(request.getBody(), request.getHeader());
            return scrcuRequest;
        }
        request.setHeader(new RequestHeader("", "", "", "", ""));
        if (appId == null || "".equals(appId)) {
            logger.error("errorCode:OP00011002;errorMsg:\u8bbe\u7f6e\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
            throw new ScrcuApiException("OP00011004", "\u8bbe\u7f6e\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (version == null || "".equals(version)) {
            request.getHeader().setVersion("1.0.0");
            request.getHeader().setAppId(appId);
            request.getHeader().setRequestTime(ScrcuUtil.requestTimeDate());
            request.getHeader().setRequestId(String.valueOf(ScrcuUtil.requestTime()) + appId + ScrcuUtil.requestId());
            request.getHeader().setAppSecret(appSecret);
            ScrcuRequest scrcuRequest = new ScrcuRequest(request.getBody(), request.getHeader());
            return scrcuRequest;
        }
        request.getHeader().setAppId(appId);
        request.getHeader().setVersion(version);
        request.getHeader().setRequestTime(ScrcuUtil.requestTimeDate());
        request.getHeader().setRequestId(String.valueOf(ScrcuUtil.requestTime()) + appId + ScrcuUtil.requestId());
        request.getHeader().setAppSecret(appSecret);
        ScrcuRequest scrcuRequest = new ScrcuRequest(request.getBody(), request.getHeader());
        return scrcuRequest;
    }

    public static String encry(SM2 encrSm2, ScrcuRequest request, String encrType) throws ScrcuApiException {
        try {
            if (request.getBody() instanceof String && request.getBody() != null && !"".equals(request.getBody())) {
                HashMap bodymap = JSONObject.parseObject(String.valueOf(request.getBody()), HashMap.class);
                request.setBody(bodymap);
            }
            request.getHeader().setFmKey("");
            request.getHeader().setSignData("");
            String requestJson = JSONObject.toJSONString(request);
            JSONObject requestJsonObject = JSONObject.parseObject(requestJson);
            String bodyData = requestJsonObject.getString("body");
            byte[] encrData = null;
            if ("0".equals(encrType)) {
                encrData = encrSm2.encrypt(bodyData.getBytes("UTF-8"));
            } else if ("1".equals(encrType)) {
                SymmetricKey sm4 = SymmetricKey.newInstance(SymmetricAlg.SM4, 128);
                byte[] outkey = sm4.getValue();
                encrData = bodyData.getBytes("UTF-8").length % 16 == 0 ? sm4.encryptECB(bodyData.getBytes("UTF-8"), Padding.NoPadding) : sm4.encryptECB(bodyData.getBytes("UTF-8"), Padding.ZeroPadding);
                String fragmentKey = Hex.encode(encrSm2.encryptWithC1C2C3(outkey));
                request.getHeader().setFmKey(fragmentKey);
            }
            request.setBody(Hex.encode(encrData));
            String requestData = JSONObject.toJSONString(request);
            return requestData;
        }
        catch (Exception e) {
            logger.error("errorCode:OP00010089;errorMsg:\u52a0\u5bc6\u5931\u8d25!");
            logger.error("\u9519\u8bef\u4fe1\u606f:{}", e);
            throw new ScrcuApiException("OP00010089", "\u52a0\u5bc6\u5931\u8d25\uff01");
        }
    }

    public static String sign(SM2 signSm2, ScrcuRequest request) throws ScrcuApiException {
        try {
            String requestJson = JSONObject.toJSONString((Object)request, SerializerFeature.WriteMapNullValue);
            JSONObject requestJsonObject = JSONObject.parseObject(requestJson);
            String bodyData = requestJsonObject.getString("body");
            String requestId = request.getHeader().getRequestId();
            String appSecret = request.getHeader().getAppSecret();
            String requestTime = request.getHeader().getRequestTime();
            String accessToken = request.getHeader().getAccessToken();
            String appId = request.getHeader().getAppId();
            String data = String.valueOf(appId) + requestId + appSecret + requestTime + accessToken + bodyData;
            byte[] bytes = data.getBytes("UTF-8");
            byte[] signData = signSm2.sign(bytes);
            request.getHeader().setSignData(Hex.encode(signData));
            String requestData = JSONObject.toJSONString((Object)request, SerializerFeature.WriteMapNullValue);
            return requestData;
        }
        catch (Exception e) {
            logger.error("errorCode:OP00010099;errorMsg:\u52a0\u7b7e\u5931\u8d25!");
            logger.error("\u9519\u8bef\u4fe1\u606f:{}", e);
            throw new ScrcuApiException("OP00010099", "\u52a0\u7b7e\u5931\u8d25\uff01");
        }
    }

    public static ScrcuResponse verity(SM2 signSm2, String respString) throws ScrcuApiException {
        try {
            byte[] bytes;
            JSONObject respData = JSONObject.parseObject(respString);
            String respEnData = respData.getString("body");
            String head = respData.getString("header");
            JSONObject jsonHead = JSONObject.parseObject(head);
            String respSignData = jsonHead.getString("signData");
            String appId = String.valueOf(jsonHead.get("appId"));
            String responseId = String.valueOf(jsonHead.get("responseId"));
            String errorCode = String.valueOf(jsonHead.get("errorCode"));
            String accessToken = String.valueOf(jsonHead.get("accessToken"));
            String callbackUrl = String.valueOf(jsonHead.get("callbackUrl"));
            respEnData = String.valueOf(appId) + responseId + errorCode + accessToken + callbackUrl + respEnData;
            if (!errorCode.equals("0000000000")) {
                logger.error("\u9a8c\u8bc1\u8fd4\u56de\u62a5\u6587\u51fa\u9519\uff01errorCode:{},errorMsg: {}", (Object)errorCode, (Object)jsonHead.getString("errorMsg"));
                ScrcuResponse scrcuResponse = new ScrcuResponse();
                HashMap<String, String> errorMap = new HashMap<String, String>();
                errorMap.put("respCode", errorCode);
                errorMap.put("respMsg", jsonHead.getString("errorMsg"));
                String errorString = JSONObject.toJSONString(errorMap);
                scrcuResponse.setBody(errorString);
                scrcuResponse.setHeader(new ResponseHeader());
                scrcuResponse.getHeader().setCallbackUrl(callbackUrl);
                scrcuResponse.getHeader().setReserve("errorResponse");
                return scrcuResponse;
            }
            byte[] decode = Hex.decode(respSignData);
            if (signSm2.verify(decode, bytes = respEnData.getBytes("UTF-8"))) {
                ResponseHeader responseHeader = JSONObject.parseObject(head, ResponseHeader.class);
                ScrcuResponse response = new ScrcuResponse();
                response.setHeader(responseHeader);
                response.getHeader().setSignData("");
                response.setBody(respEnData);
                return response;
            }
            logger.error("\u9a8c\u8bc1\u8fd4\u56de\u62a5\u6587\u51fa\u9519\uff01errorCode:{},errorMsg: {}", (Object)errorCode, (Object)jsonHead.getString("errorMsg"));
            throw new ScrcuApiException("errorCode:" + errorCode + ";errorMsg:" + jsonHead.getString("errorMsg"));
        }
        catch (Exception e) {
            logger.error("errorCode:OP00010098;errorMsg:\u9a8c\u7b7e\u5931\u8d25!");
            logger.error("\u9519\u8bef\u4fe1\u606f:{}", e);
            throw new ScrcuApiException("OP00010098", "\u9a8c\u7b7e\u5931\u8d25!");
        }
    }

    public static CallBackRequestHeader callBackVerity(SM2 signSm2, String respString, String appSecret) throws ScrcuApiException {
        try {
            JSONObject respData = JSONObject.parseObject(respString);
            String respEnData = respData.getString("body");
            String head = respData.getString("header");
            JSONObject jsonHead = JSONObject.parseObject(head);
            String respSignData = jsonHead.getString("signData");
            String appId = String.valueOf(jsonHead.get("appId"));
            String requestId = String.valueOf(jsonHead.get("requestId"));
            String requestTime = String.valueOf(jsonHead.get("requestTime"));
            String appSecretString = appSecret;
            respEnData = String.valueOf(appId) + requestId + appSecretString + requestTime + respEnData;
            byte[] decode = Hex.decode(respSignData);
            byte[] bytes = respEnData.getBytes("UTF-8");
            if (signSm2.verify(decode, bytes)) {
                CallBackRequestHeader callBackRequestHeader = JSONObject.parseObject(head, CallBackRequestHeader.class);
                return callBackRequestHeader;
            }
            logger.error("errorCode:OP00011007;errorMsg:\u56de\u8c03\u62a5\u6587\u9a8c\u7b7e\u5931\u8d25\uff01");
            throw new ScrcuApiException("OP00011007", "\u56de\u8c03\u62a5\u6587\u9a8c\u7b7e\u5931\u8d25\uff01");
        }
        catch (Exception e) {
            logger.error("errorCode:OP00011007;errorMsg:\u56de\u8c03\u62a5\u6587\u9a8c\u7b7e\u5931\u8d25\uff01");
            logger.error("\u9519\u8bef\u4fe1\u606f:{}", e);
            throw new ScrcuApiException("OP00011007", "\u56de\u8c03\u62a5\u6587\u9a8c\u7b7e\u5931\u8d25\uff01");
        }
    }

    public static String callBackDecr(SM2 encrSm2, String respString, String encrType) throws ScrcuApiException {
        try {
            JSONObject respData = JSONObject.parseObject(respString);
            String respEnData = respData.getString("body");
            String head = respData.getString("header");
            Map map = JSONObject.parseObject(head, Map.class);
            byte[] respRealData = null;
            if ("0".equals(encrType)) {
                respRealData = encrSm2.decrypt(Hex.decode(respEnData));
            } else {
                byte[] data = Hex.decode((String)map.get("fmPwdKey"));
                byte[] decryptkey = encrSm2.decryptWithC1C2C3(data);
                SymmetricKey symmetricKey = SymmetricKey.newInstance(SymmetricAlg.SM4, decryptkey);
                byte[] decryptdata = Hex.decode(respEnData);
                respRealData = symmetricKey.decryptECB(decryptdata, Padding.ZeroPadding);
            }
            String respRealString = new String(respRealData, "UTF-8");
            return respRealString;
        }
        catch (Exception e) {
            logger.error("errorCode:OP00011008;errorMsg:\u56de\u8c03\u62a5\u6587\u89e3\u5bc6\u5931\u8d25\uff01");
            logger.error("\u9519\u8bef\u4fe1\u606f:{}", e);
            throw new ScrcuApiException("OP00011008", "\u56de\u8c03\u62a5\u6587\u89e3\u5bc6\u5931\u8d25\uff01");
        }
    }

    public static ScrcuResponse decr(SM2 encrSm2, String respString, String encrType) throws ScrcuApiException {
        try {
            JSONObject respData = JSONObject.parseObject(respString);
            String respEnData = respData.getString("body");
            String head = respData.getString("header");
            ResponseHeader responseHeader = JSONObject.parseObject(head, ResponseHeader.class);
            ScrcuResponse response = new ScrcuResponse();
            response.setHeader(responseHeader);
            response.getHeader().setSignData("");
            byte[] respRealData = null;
            if ("0".equals(encrType)) {
                respRealData = encrSm2.decrypt(Hex.decode(respEnData));
            } else {
                byte[] data = Hex.decode(response.getHeader().getFmKey());
                byte[] decryptkey = encrSm2.decryptWithC1C2C3(data);
                SymmetricKey symmetricKey = SymmetricKey.newInstance(SymmetricAlg.SM4, decryptkey);
                byte[] decryptdata = Hex.decode(respEnData);
                respRealData = symmetricKey.decryptECB(decryptdata, Padding.ZeroPadding);
            }
            String respRealString = new String(respRealData, "UTF-8");
            response.setBody(respRealString);
            response.getHeader().setFmKey("");
            return response;
        }
        catch (Exception e) {
            logger.error("errorCode:OP00010088;errorMsg:\u89e3\u5bc6\u5931\u8d25\uff01");
            logger.error("\u9519\u8bef\u4fe1\u606f:{}", e);
            throw new ScrcuApiException("OP00010088", "\u89e3\u5bc6\u5931\u8d25\uff01");
        }
    }

    public static byte[] getJavaBytes(String data) throws UnsupportedEncodingException {
        return data.getBytes("UTF-8");
    }

    public static String getJavaString(byte[] data) throws UnsupportedEncodingException {
        return new String(data, "UTF-8");
    }

    public static String encrySign(SM2 encrSm2, SM2 signSm2, ScrcuRequest request, String encrType) throws ScrcuApiException {
        ScrcuUtil.encry(encrSm2, request, encrType);
        String sign = ScrcuUtil.sign(signSm2, request);
        return sign;
    }

    public static ScrcuResponse decrVerity(SM2 encrSm2, SM2 signSm2, String respString, String encrType) throws ScrcuApiException {
        ScrcuResponse verity = ScrcuUtil.verity(signSm2, respString);
        if (verity.getHeader().getReserve().equals("errorResponse")) {
            return verity;
        }
        ScrcuResponse decr = ScrcuUtil.decr(encrSm2, respString, encrType);
        return decr;
    }

    public static String callBackDecrVerity(SM2 encrSm2, SM2 signSm2, String respString, String encrType, String appSecretString) throws Exception {
        CallBackRequestHeader verity = ScrcuUtil.callBackVerity(signSm2, respString, appSecretString);
        String data = ScrcuUtil.callBackDecr(encrSm2, respString, encrType);
        return data;
    }
}

