/*
 * Decompiled with CFR 0.152.
 */
package com.scrcu.opensdk.util;

import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RSAUtil {
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public KeyPair getKeyPair() throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(1024);
        return generator.generateKeyPair();
    }

    private PrivateKey getPrivateKeyP(String privateKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        byte[] decodedKey = Base64.decodeBase64(privateKey.getBytes("UTF-8"));
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(decodedKey);
        return keyFactory.generatePrivate(keySpec);
    }

    private PublicKey getPublicKeyP(String publicKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        byte[] decodedKey = Base64.decodeBase64(publicKey.getBytes("UTF-8"));
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(decodedKey);
        return keyFactory.generatePublic(keySpec);
    }

    public String encrypt(String data, String pubKey) throws Exception {
        PublicKey publicKey = this.getPublicKeyP(pubKey);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        int inputLen = data.getBytes("UTF-8").length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offset = 0;
        int i = 0;
        while (inputLen - offset > 0) {
            byte[] cache = inputLen - offset > 117 ? cipher.doFinal(data.getBytes("UTF-8"), offset, 117) : cipher.doFinal(data.getBytes("UTF-8"), offset, inputLen - offset);
            out.write(cache, 0, cache.length);
            offset = ++i * 117;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return new String(Base64.encodeBase64String(encryptedData));
    }

    public String decrypt(String data, String priKey) throws Exception {
        PrivateKey privateKey = this.getPrivateKeyP(priKey);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        byte[] dataBytes = Base64.decodeBase64(data);
        int inputLen = dataBytes.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offset = 0;
        int i = 0;
        while (inputLen - offset > 0) {
            byte[] cache = inputLen - offset > 128 ? cipher.doFinal(dataBytes, offset, 128) : cipher.doFinal(dataBytes, offset, inputLen - offset);
            out.write(cache, 0, cache.length);
            offset = ++i * 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return new String(decryptedData, "UTF-8");
    }

    public String sign(String data, String priKey) throws Exception {
        PrivateKey privateKey = this.getPrivateKeyP(priKey);
        byte[] keyBytes = privateKey.getEncoded();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey key = keyFactory.generatePrivate(keySpec);
        Signature signature = Signature.getInstance("MD5withRSA");
        signature.initSign(key);
        signature.update(data.getBytes("UTF-8"));
        return new String(Base64.encodeBase64(signature.sign()));
    }

    public boolean verify(String srcData, String pubKey, String sign) throws Exception {
        PublicKey publicKey = this.getPublicKeyP(pubKey);
        byte[] keyBytes = publicKey.getEncoded();
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey key = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance("MD5withRSA");
        signature.initVerify(key);
        signature.update(srcData.getBytes("UTF-8"));
        return signature.verify(Base64.decodeBase64(sign.getBytes("UTF-8")));
    }

    public String getPublicKey(KeyPair keyPair) {
        return new String(Base64.encodeBase64(keyPair.getPublic().getEncoded()));
    }

    public String getPrivateKey(KeyPair keyPair) {
        return new String(Base64.encodeBase64(keyPair.getPrivate().getEncoded()));
    }
}

