/*
 * Decompiled with CFR 0.152.
 */
package com.scrcu.opensdk.util;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public class AESUtil {
    public static final String KEY_ALGORITHM = "AES";
    public static final String CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    private static Key toKey(byte[] key) {
        SecretKeySpec secretKey = new SecretKeySpec(key, KEY_ALGORITHM);
        return secretKey;
    }

    public static byte[] decrpyt(byte[] data, byte[] key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Key k = AESUtil.toKey(key);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, k);
        return cipher.doFinal(data);
    }

    public static byte[] encrypt(byte[] data, byte[] key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Key k = AESUtil.toKey(key);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, k);
        return cipher.doFinal(data);
    }

    public static byte[] initKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM);
        keyGenerator.init(128);
        SecretKey secretKey = keyGenerator.generateKey();
        return secretKey.getEncoded();
    }

    public static String initKeyString() throws NoSuchAlgorithmException {
        return Base64.encodeBase64String(AESUtil.initKey());
    }

    public static byte[] getKey(String key) {
        return Base64.decodeBase64(key);
    }

    public static byte[] decrypt(byte[] data, String key) throws IllegalBlockSizeException, InvalidKeyException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        return AESUtil.decrpyt(data, AESUtil.getKey(key));
    }

    public static byte[] encrypt(byte[] data, String key) throws IllegalBlockSizeException, InvalidKeyException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        return AESUtil.encrypt(data, AESUtil.getKey(key));
    }

    public static String shaHex(byte[] data) {
        return DigestUtils.md5Hex(data);
    }

    public static boolean vailidate(byte[] data, String messageDigest) {
        return messageDigest.equals(AESUtil.shaHex(data));
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException {
        String data = "123";
        byte[] initKey = AESUtil.initKey();
        byte[] encrypt = AESUtil.encrypt(data.getBytes(), initKey);
        String encodeBase64String = Base64.encodeBase64String(encrypt);
        System.out.println(encodeBase64String);
        System.out.println(new String(encrypt));
    }
}

