/*
 * Decompiled with CFR 0.152.
 */
package com.scrcu.opensdk;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.scrcu.opensdk.ScrcuRequest;
import com.scrcu.opensdk.ScrcuResponse;
import com.scrcu.opensdk.exception.ScrcuApiException;
import com.scrcu.opensdk.util.RSAUtil;
import com.scrcu.opensdk.util.ScrcuUtil;
import io.soft.algorithm.api.Padding;
import io.soft.algorithm.api.SM2;
import io.soft.algorithm.api.SymmetricAlg;
import io.soft.algorithm.api.SymmetricKey;
import io.soft.algorithm.util.Hex;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScrcuSdk
extends RSAUtil {
    private static Logger logger = LoggerFactory.getLogger(ScrcuSdk.class);
    private static RequestConfig requestConfig;
    private static String appId;
    private static String appSecret;
    private static byte[] appDPriK;
    private static byte[] openEPubK;
    private static byte[] appSPriK;
    private static byte[] openVPubK;
    private static Boolean ENCRY_SATE;
    private static Boolean SIGN_SATE;
    private static String DomainName;
    private static volatile ScrcuSdk instance;
    private static int MAX_TIMEOUT;
    private static String proxyIp;
    private static String proxyPort;
    private static boolean isProxy;

    static {
        appDPriK = null;
        openEPubK = null;
        appSPriK = null;
        openVPubK = null;
        ENCRY_SATE = false;
        SIGN_SATE = false;
        DomainName = "https://open.scrcu.com/open-gate";
        instance = null;
        MAX_TIMEOUT = 120000;
        proxyIp = "";
        proxyPort = "";
        isProxy = false;
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(MAX_TIMEOUT);
        configBuilder.setSocketTimeout(MAX_TIMEOUT);
        configBuilder.setConnectionRequestTimeout(MAX_TIMEOUT);
        configBuilder.setStaleConnectionCheckEnabled(true);
        requestConfig = configBuilder.build();
    }

    public void resetDomainName() {
        DomainName = "https://open.scrcu.com/open-gate";
    }

    public void setDomainName(String domainName) {
        DomainName = domainName;
    }

    private ScrcuSdk() {
    }

    public static void clear() {
        instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScrcuSdk getInstance(String appId, String appSecret) throws ScrcuApiException {
        if (instance != null) return instance;
        Class<ScrcuSdk> clazz = ScrcuSdk.class;
        synchronized (ScrcuSdk.class) {
            if (instance != null) return instance;
            if ("".equals(appId) || appId == null || appSecret == null || "".equals(appSecret) || appSecret.length() != 36) {
                logger.error("errorCode:OP00011005;errorMsg:SDK\u521d\u59cb\u5316\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
                throw new ScrcuApiException("OP00011005", "SDK\u521d\u59cb\u5316\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
            }
            ScrcuSdk.appId = appId;
            ScrcuSdk.appSecret = appSecret;
            instance = new ScrcuSdk();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScrcuSdk getInstance(String appId, String appSecret, String openEPubK, String appDPriK) throws ScrcuApiException {
        if (instance != null) return instance;
        Class<ScrcuSdk> clazz = ScrcuSdk.class;
        synchronized (ScrcuSdk.class) {
            if (instance != null) return instance;
            try {
                if ("".equals(appId) || appId == null || "".equals(appDPriK) || appDPriK == null || "".equals(openEPubK) || openEPubK == null || appSecret == null || "".equals(appSecret) || appSecret.length() != 36) {
                    logger.error("errorCode:OP00011005;errorMsg:SDK\u521d\u59cb\u5316\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
                    throw new ScrcuApiException("OP00011005", "SDK\u521d\u59cb\u5316\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
                }
                ScrcuSdk.appId = appId;
                ScrcuSdk.openEPubK = Hex.decode(openEPubK);
                ScrcuSdk.appDPriK = Hex.decode(appDPriK);
                ScrcuSdk.appSecret = appSecret;
                ENCRY_SATE = true;
                instance = new ScrcuSdk();
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return instance;
            }
            catch (Exception e) {
                logger.error("errorCode:OP00011003;errorMsg:SDK\u521d\u59cb\u5316\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
                throw new ScrcuApiException("OP00011003", "SDK\u521d\u59cb\u5316\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScrcuSdk getInstance(String appId, String appSecret, String openEPubK, String appDPriK, String openVPubK, String appSPriK) throws ScrcuApiException {
        if (instance != null) return instance;
        Class<ScrcuSdk> clazz = ScrcuSdk.class;
        synchronized (ScrcuSdk.class) {
            if (instance != null) return instance;
            try {
                if ("".equals(appId) || appId == null || "".equals(appSPriK) || appSPriK == null || "".equals(appDPriK) || appDPriK == null || "".equals(openEPubK) || openEPubK == null || appSecret == null || "".equals(appSecret) || appSecret.length() != 36) {
                    logger.error("errorCode:OP00011005;errorMsg:SDK\u521d\u59cb\u5316\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
                    throw new ScrcuApiException("OP00011005", "SDK\u521d\u59cb\u5316\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
                }
                ScrcuSdk.appId = appId;
                ScrcuSdk.appSecret = appSecret;
                ScrcuSdk.openEPubK = Hex.decode(openEPubK);
                ScrcuSdk.appDPriK = Hex.decode(appDPriK);
                ScrcuSdk.openVPubK = Hex.decode(openVPubK);
                ScrcuSdk.appSPriK = Hex.decode(appSPriK);
                instance = new ScrcuSdk();
                ENCRY_SATE = true;
                SIGN_SATE = true;
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return instance;
            }
            catch (Exception e) {
                logger.error("errorCode:OP00011003;errorMsg:SDK\u521d\u59cb\u5316\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
                throw new ScrcuApiException("OP00011003", "SDK\u521d\u59cb\u5316\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScrcuSdk getInstance(String appId, String appSecret, StringBuilder openVPubK, StringBuilder appSPriK) throws ScrcuApiException {
        if (instance != null) return instance;
        Class<ScrcuSdk> clazz = ScrcuSdk.class;
        synchronized (ScrcuSdk.class) {
            if (instance != null) return instance;
            try {
                if ("".equals(appId) || appId == null || "".equals(appSPriK) || appSPriK == null || "".equals(openVPubK) || openVPubK == null || appSecret == null || "".equals(appSecret) || appSecret.length() != 36) {
                    logger.error("errorCode:OP00011005;errorMsg:SDK\u521d\u59cb\u5316\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
                    throw new ScrcuApiException("OP00011005", "SDK\u521d\u59cb\u5316\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
                }
                ScrcuSdk.appId = appId;
                ScrcuSdk.appSecret = appSecret;
                String string = openVPubK.toString();
                String string2 = appSPriK.toString();
                ScrcuSdk.openVPubK = Hex.decode(string);
                ScrcuSdk.appSPriK = Hex.decode(string2);
                SIGN_SATE = true;
                instance = new ScrcuSdk();
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return instance;
            }
            catch (Exception e) {
                logger.error("errorCode:OP00011003;errorMsg:SDK\u521d\u59cb\u5316\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
                throw new ScrcuApiException("OP00011003", "SDK\u521d\u59cb\u5316\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
            }
        }
    }

    public void cleanAllKeys() {
        appDPriK = null;
        openEPubK = null;
        appSPriK = null;
        openVPubK = null;
        ENCRY_SATE = false;
        SIGN_SATE = false;
    }

    public void cleanEncrKeys() {
        appDPriK = null;
        openEPubK = null;
        ENCRY_SATE = false;
    }

    public void cleanSignKeys() {
        appSPriK = null;
        openVPubK = null;
        SIGN_SATE = false;
    }

    public ScrcuResponse call(String url, ScrcuRequest scrcuRequest, String version) throws ScrcuApiException {
        ScrcuRequest request = ScrcuUtil.createRequest(scrcuRequest, appSecret, appId, version);
        ScrcuUtil.checkUrl(url);
        url = String.valueOf(DomainName) + url;
        if (ENCRY_SATE.booleanValue() && SIGN_SATE.booleanValue()) {
            SM2 encrSM2 = SM2.newInstance(openEPubK, appDPriK);
            SM2 signSM2 = SM2.newInstance(openVPubK, appSPriK);
            String requestData = ScrcuUtil.encrySign(encrSM2, signSM2, request, "1");
            String respString = ScrcuSdk.doPostSSL(url, requestData);
            ScrcuResponse response = ScrcuUtil.decrVerity(encrSM2, signSM2, respString, "1");
            return response;
        }
        if (ENCRY_SATE.booleanValue() && !SIGN_SATE.booleanValue()) {
            SM2 encrSM2 = SM2.newInstance(openEPubK, appDPriK);
            String requestData = ScrcuUtil.encry(encrSM2, request, "1");
            String respString = ScrcuSdk.doPostSSL(url, requestData);
            ScrcuResponse response = ScrcuUtil.decr(encrSM2, respString, "1");
            return response;
        }
        if (!ENCRY_SATE.booleanValue() && SIGN_SATE.booleanValue()) {
            SM2 signSM2 = SM2.newInstance(openVPubK, appSPriK);
            String requestData = ScrcuUtil.sign(signSM2, request);
            String respString = ScrcuSdk.doPostSSL(url, requestData);
            ScrcuResponse response = ScrcuUtil.verity(signSM2, respString);
            return response;
        }
        String respString = ScrcuSdk.doPostSSL(url, JSONObject.toJSONString((Object)request, SerializerFeature.WriteMapNullValue));
        ScrcuResponse response = JSONObject.parseObject(respString, ScrcuResponse.class);
        return response;
    }

    public String getCallBackJson(String callBackData) throws Exception {
        if (appDPriK == null || appId == null || openEPubK == null || openVPubK == null || appSPriK == null || appSecret == null || appSecret.length() != 36) {
            logger.error("errorCode:OP00011006;errorMsg:\u9a8c\u8bc1\u542f\u52a8\u56de\u8c03\u62a5\u6587\u89e3\u6790\u5931\u8d25\uff01\u8bf7\u786e\u8ba4\u5bc6\u94a5,appId,appSecret\u662f\u5426\u6b63\u786e\uff01");
            throw new ScrcuApiException("OP00011006", "errorCode:OP00011006 errorMsg:\u9a8c\u8bc1\u542f\u52a8\u56de\u8c03\u62a5\u6587\u89e3\u6790\u5931\u8d25\uff01\u8bf7\u786e\u8ba4\u5bc6\u94a5,appId,appSecret\u662f\u5426\u6b63\u786e\uff01");
        }
        SM2 encrSM2 = SM2.newInstance(openEPubK, appDPriK);
        SM2 signSM2 = SM2.newInstance(openVPubK, appSPriK);
        String response = ScrcuUtil.callBackDecrVerity(encrSM2, signSM2, callBackData, "1", appSecret);
        return response;
    }

    public static int getMAX_TIMEOUT() {
        return MAX_TIMEOUT;
    }

    public static void setMAX_TIMEOUT(int mAX_TIMEOUT) {
        MAX_TIMEOUT = mAX_TIMEOUT;
    }

    public void setProxy(String proxy, String proxyP) {
        proxyIp = proxy;
        proxyPort = proxyP;
        isProxy = true;
    }

    public static boolean getIsProxy() {
        return isProxy;
    }

    private static HashMap<String, String> getAesData(Object json) throws ScrcuApiException {
        try {
            JSONObject jsonObject = JSONObject.parseObject(String.valueOf(json));
            JSONObject header = (JSONObject)jsonObject.get("header");
            String appId = header.getString("appId");
            String requestTime = header.getString("requestTime");
            String requestId = header.getString("requestId");
            String flagKey = Hex.encode(requestTime.getBytes("UTF-8"));
            String bodyData = String.valueOf(String.valueOf(appId)) + requestId;
            SymmetricKey sm4 = SymmetricKey.newInstance(SymmetricAlg.SM4, 128);
            byte[] encrData = null;
            encrData = bodyData.getBytes("UTF-8").length % 16 == 0 ? sm4.encryptECB(bodyData.getBytes("UTF-8"), Padding.NoPadding) : sm4.encryptECB(bodyData.getBytes("UTF-8"), Padding.ZeroPadding);
            String en = Hex.encode(encrData);
            String keyString = Hex.encode(sm4.getValue());
            String flagValue = String.valueOf(String.valueOf(en)) + keyString;
            HashMap<String, String> flagMap = new HashMap<String, String>();
            flagMap.put("key", flagKey);
            flagMap.put("value", flagValue);
            return flagMap;
        }
        catch (Exception e) {
            logger.error("{}", e);
            throw new ScrcuApiException("OP00011015", "\u8bfb\u53d6SDK\u8c03\u7528\u683c\u5f0f\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8c03\u7528\u7f16\u7801");
        }
    }

    private static String doPostSSL(String apiUrl, Object json) throws ScrcuApiException {
        HttpPost httpPost = new HttpPost(apiUrl);
        HttpResponse response = null;
        CloseableHttpClient httpClient = null;
        String httpStr = null;
        if (ScrcuSdk.getIsProxy()) {
            HttpHost proxy = ScrcuSdk.setProxyHttpClient(proxyIp, proxyPort);
            RequestConfig requestConfig = RequestConfig.custom().setProxy(proxy).build();
            httpClient = HttpClients.custom().setSSLSocketFactory(ScrcuSdk.createSSLConnSocketFactory()).setDefaultRequestConfig(requestConfig).build();
            httpPost.setConfig(requestConfig);
        } else {
            httpClient = HttpClients.custom().setSSLSocketFactory(ScrcuSdk.createSSLConnSocketFactory()).setDefaultRequestConfig(requestConfig).build();
            httpPost.setConfig(requestConfig);
        }
        try {
            StringEntity stringEntity = new StringEntity(json.toString(), "UTF-8");
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            HashMap<String, String> flagMap = ScrcuSdk.getAesData(json);
            httpPost.setHeader(flagMap.get("key"), flagMap.get("value"));
            httpPost.setEntity(stringEntity);
            httpPost.setHeader("apiType", "sdk");
            httpPost.setHeader("sdkVersion", "1.1.8");
            httpPost.addHeader("Connection", "Close");
            response = httpClient.execute(httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                return null;
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return null;
            }
            try {
                httpStr = EntityUtils.toString(entity, "utf-8");
            }
            catch (Exception e) {
                logger.error("errorCode:OP00012001;errorMsg:\u8fde\u63a5\u51fa\u9519\u8bf7\u68c0\u67e5\u8fde\u63a5\u81f3\u8be5URL\u7684\u7f51\u7edc\u73af\u5883{},\u62a5\u9519\u4fe1\u606f{}", (Object)apiUrl, (Object)e);
                throw new ScrcuApiException("OP00012001", "errorMsg:\u8fde\u63a5\u51fa\u9519\u8bf7\u68c0\u67e5\u8fde\u63a5\u81f3\u8be5URL\u7684\u7f51\u7edc\u73af\u5883:" + apiUrl + ",\u62a5\u9519\u4fe1\u606f:" + e);
            }
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume(response.getEntity());
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (response != null) {
            try {
                EntityUtils.consume(response.getEntity());
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return httpStr;
    }

    private static SSLConnectionSocketFactory createSSLConnSocketFactory() throws ScrcuApiException {
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                @Override
                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            sslsf = new SSLConnectionSocketFactory(sslContext, new X509HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }

                @Override
                public void verify(String host, SSLSocket ssl) throws IOException {
                }

                @Override
                public void verify(String host, X509Certificate cert) throws SSLException {
                }

                @Override
                public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                }
            });
        }
        catch (Exception e) {
            logger.error("errorCode:OP00012002;errorMsg:\u521d\u59cb\u5316SSL\u5b89\u5168\u8fde\u63a5\u5931\u8d25\uff0c\u62a5\u9519\u4fe1\u606f:{}", e);
            throw new ScrcuApiException("OP00012002", "\u521d\u59cb\u5316SSL\u5b89\u5168\u8fde\u63a5\u5931\u8d25\uff0c\u62a5\u9519\u4fe1\u606f:" + e);
        }
        return sslsf;
    }

    private static HttpHost setProxyHttpClient(String proxyIp, String proxyPort) {
        int intProxyPort = Integer.parseInt(proxyPort);
        HttpHost proxy = new HttpHost(proxyIp, intProxyPort);
        return proxy;
    }
}

