/*
 * Decompiled with CFR 0.152.
 */
package com.scrcu.opensdk;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.scrcu.opensdk.exception.ScrcuApiException;
import com.scrcu.opensdk.internal.ResponseHeader;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;

public class ScrcuResponse {
    private ResponseHeader header;
    @JSONField(jsonDirect=true)
    private Object body;

    public Map<String, Object> getBody() throws ScrcuApiException {
        try {
            return JSONObject.parseObject(String.valueOf(this.body), Map.class);
        }
        catch (Exception e) {
            throw new ScrcuApiException("OP00017001", "\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff01");
        }
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public <T> T getBody(Class<T> classz) throws ScrcuApiException {
        try {
            return JSONObject.parseObject(this.body.toString(), classz);
        }
        catch (Exception e) {
            throw new ScrcuApiException("OP00010087", "\u8f6c\u6362\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u8be5\u7c7b:" + classz);
        }
    }

    public String getBodyString() {
        String bodyJson = StringEscapeUtils.unescapeJava(JSONObject.toJSONString(this.body, SerializerFeature.WriteNonStringKeyAsString));
        return bodyJson;
    }

    public String getHeaderString() {
        String headerJson = StringEscapeUtils.unescapeJava(JSONObject.toJSONString((Object)this.header, SerializerFeature.WriteMapNullValue));
        return headerJson;
    }

    public void setHeader(ResponseHeader header) {
        this.header = header;
    }

    public ResponseHeader getHeader() {
        return this.header;
    }

    public String toString() {
        String bodyString = this.getBodyString();
        String substring = bodyString.substring(1, bodyString.lastIndexOf("\""));
        return String.valueOf(this.header.toString()) + ", \"body\":" + substring + "}";
    }

    public String getErrorMsg() {
        return this.getHeader().getErrorMsg();
    }

    public String getErrorCode() {
        return this.getHeader().getErrorCode();
    }

    public String getAccessToken() {
        return this.getHeader().getAccessToken();
    }

    public String getAppId() {
        return this.getHeader().getAppId();
    }

    public String getCallbackUrl() {
        return this.getHeader().getCallbackUrl();
    }

    public String getCharset() {
        return this.getHeader().getCharset();
    }

    public String getRequestId() {
        return this.getHeader().getRequestId();
    }

    public String getResponseId() {
        return this.getHeader().getResponseId();
    }

    public String getResponseTime() {
        return this.getHeader().getResponseTime();
    }
}

