SELECT
    *
FROM
    (
        SELECT
            u2.f_filialeid,
            u2.f_balance_amount,
            u2.f_iot_times,
            u4.f_userinfo_id,
            u4.f_userinfo_code,
            u4.f_balance,
            u4.f_user_name,
            u4.f_user_phone,
            u3.f_address,
            u2.f_user_type,
            u2.f_gasproperties,
            isnull(u2.f_total_gas,0) f_total_gas,
            isnull(u2.f_total_fee,0) f_total_fee,
            u2.f_user_id,
            u2.f_userfiles_id,
            u2.f_meter_base,
            u1.f_source,
            gb.f_meter_type,
            u1.f_surplus_id,
            gb.f_meter_brand,
            gm.f_meter_style,
            u2.f_price_id,
            u2.f_meternumber,
            u1.pregas AS pregas,
            sp.f_price_name,
            sp.f_price_type,
            s.f_change_price1,
            s.f_change_price2,
            s.f_change_price3,
            s.f_surplus_fee,
            s.f_surplus_fee1,
            s.f_surplus_fee2,
            s.f_surplus_fee3,
            u1.f_stair_gas1,
            u1.f_stair_gas2,
            u1.f_stair_gas3,
            u1.f_stair_price1,
            u1.f_stair_price2,
            u1.f_stair_price3,
            s.f_whether_pay,
            u1.f_last_tablebase,
            u1.f_start_date,
            u1.f_end_date,
            u1.f_tablebase
        FROM
            (
                SELECT
                    f_stair_gas1,
                    f_stair_gas2,
                    f_stair_gas3,
                    f_stair_price1,
                    f_stair_price2,
                    f_stair_price3,
                    f_surplus_id,
                    f_userfiles_id,
                    f_stairprice_id,
                    f_start_date,
                    f_end_date,
                    f_oughtamount AS pregas,
                    '物联网表抄表' f_source,
                    f_last_tablebase,
                    f_tablebase
                FROM
                    (
                        SELECT MAX
                                   ( f_input_date ) f_end_date,
                               sum(isnull(f_stair_gas1,0)) f_stair_gas1,
                               sum(isnull(f_stair_gas2,0)) f_stair_gas2,
                               sum(isnull(f_stair_gas3,0)) f_stair_gas3,
                               f_stair_price1,
                               f_stair_price2,
                               f_stair_price3,
                               MIN ( f_input_date ) f_start_date,
                               SUM ( f_oughtamount ) f_oughtamount,
                               SUM ( f_oughtfee ) f_oughtfee,
                               MAX ( f_tablebase ) f_tablebase,
                               MIN ( f_last_tablebase ) f_last_tablebase,
                               f_stairprice_id,
                               f_surplus_id,
                               f_userfiles_id
                        FROM
                            t_handplan
                        WHERE
                            f_operate_date BETWEEN '{startDate} 00:00:00'
                                AND '{endDate} 23:59:59'
                          AND f_meter_classify = '物联网表'
                          AND f_hand_state = '有效'
                          AND f_meter_state = '已抄表'
                        GROUP BY
                            f_userfiles_id,
                            f_stairprice_id,
                            f_stair_price1,
                            f_stair_price2,
                            f_stair_price3,
                            f_surplus_id
                    ) a
            ) u1
                LEFT JOIN t_userfiles u2 ON u1.f_userfiles_id = u2.f_userfiles_id
                LEFT JOIN t_user_address u3 ON u2.f_useraddress_id = u3.id
                LEFT JOIN t_gasbrand gb ON gb.id = u2.f_gasbrand_id
                LEFT JOIN t_gasmodel gm ON gm.id = u2.f_gasmodel_id
                LEFT JOIN t_stairprice sp ON sp.id = u1.f_stairprice_id
                LEFT JOIN t_userinfo u4 ON u2.f_userinfo_id = u4.f_userinfo_id
                LEFT JOIN ( SELECT  id,    f_surplus_fee1,f_surplus_fee2,f_surplus_fee3,f_change_price1,f_change_price2,f_change_price3,f_whether_pay, f_surplus_fee FROM t_surplus_detail WHERE f_state = '有效' ) s
                          ON u1.f_surplus_id = s.id
        WHERE
            { condition }
          AND u1.pregas > 0
    ) a
