SELECT
    *
FROM (
         SELECT
             u2.f_filialeid,
             u4.f_userinfo_id,
             u4.f_userinfo_code,
             u4.f_user_name,
             u4.f_user_phone,
             u3.f_address,
             u2.f_user_type,
             u2.f_gasproperties,
             u2.f_total_gas,
             u2.f_user_id,
             u2.f_userfiles_id,
             u2.f_meter_base,
             u1.f_source,
             u1.f_meter_type,
             u1.f_stairprice_id,
             u1.f_handplan_id,
             u1.f_meter_brand,
             u1.f_meter_style,
             u1.f_input_date,
             u2.f_price_id,
             u2.f_meternumber,
             u1.pregas as pregas,
             sp1.f_price_name,
             dp1.f_price,
             isnull(f_old_price,0) f_old_price,
             isnull(s.f_new_price,0) f_new_price,
             s.f_change_price,
             s.f_surplus_fee,
             u1.f_last_tablebase,
             u1.f_tablebase
         FROM
             (
                 SELECT
                     id as f_handplan_id,
                     f_userfiles_id,
                     f_userinfo_id,
                     f_meter_brand,
                     f_operate_date f_input_date,
                     f_meter_style,
                     f_price_id,
                     f_stairprice_id,
                     f_meter_type,
                     f_pregas as pregas,
                     f_type f_source,
--         isnull(f_new_price,0) f_new_price,
--         f_change_price,
--         f_surplus_fee,
                     f_last_tablebase,
                     f_tablebase
                 FROM
                     t_sellinggas
                 WHERE
                     f_operate_date BETWEEN '{startDate} 00:00:00'
                         AND '{endDate} 23:59:59'
                   AND f_meter_type = '气量卡表'
                   AND f_state = '有效'
             ) u1
                 LEFT JOIN t_userfiles u2 ON u1.f_userfiles_id = u2.f_userfiles_id
                 LEFT JOIN t_user_address u3 ON u2.f_useraddress_id = u3.id
                 LEFT JOIN t_stairprice sp1 on sp1.id = u1.f_stairprice_id
                 LEFT JOIN t_detailprice dp1 on sp1.id = dp1.f_stairprice_id
                 LEFT JOIN t_userinfo u4 ON u3.f_userinfo_id = u4.f_userinfo_id
                 left join (select * from t_surplus_detail where f_state='有效') s
                           on u1.f_handplan_id = s.f_handplan_id and u1.f_userinfo_id=s.f_userinfo_id
         WHERE
             {condition} and sp1.f_price_type='固定气价' AND u1.pregas > 0
     ) a
ORDER BY
    f_handplan_id asc
