select * from (
                  select ui.f_userinfo_code,
                         ui.f_userinfo_id,
                         ui.f_user_name,
                         ui.f_user_phone,
                         ua.f_address,
                         case when f_hetong is not null then '有' else '无' end f_hetong,
                         case when f_changemeter is not null then '有' else '无' end f_changemeter,
                         case when f_security_check is not null then '有' else '无' end f_security_check,
                         case when f_idcard is not null then '有' else '无' end f_idcard,
                         case when f_house is not null then '有' else '无' end f_house,
                         case when f_responsibility_letter is not null then '有' else '无' end f_responsibility_letter,
                         ui.f_orgid,
                         ui.f_orgname
                  from t_userinfo ui
                           left join t_user_address ua on ui.f_userinfo_id = ua.f_userinfo_id
                           left join
                       (select f_blobid f_hetong
                        from t_files
                        where fusetype = '合同照片'
                        group by f_blobid) hetong on cast(ui.f_userinfo_id as varchar) = hetong.f_hetong
                           left join
                       (select f_blobid f_changemeter
                        from t_files
                        where fusetype = '换表&清零'
                        group by f_blobid) changemeter on cast(ui.f_userinfo_id as varchar) = changemeter.f_changemeter
                           left join
                       (select f_blobid f_security_check
                        from t_files
                        where fusetype = '安检照片'
                          AND f_filename NOT LIKE '%.amr'
                        group by f_blobid) security_check on cast(ui.f_userinfo_id as varchar) = security_check.f_security_check
                       left join
                       (select f_blobid f_idcard
                        from t_files
                        where fusetype = '身份证照片'
                        group by f_blobid) idcard on cast(ui.f_userinfo_id as varchar) = idcard.f_idcard
                        left join
                       (select f_blobid f_house
                        from t_files
                        where fusetype = '房产证照片'
                        group by f_blobid) house on cast(ui.f_userinfo_id as varchar) = house.f_house
                        left join
                       (select f_blobid f_responsibility_letter
                        from t_files
                        where fusetype = '承诺书照片'
                        group by f_blobid) responsibility_letter on cast(ui.f_userinfo_id as varchar) = responsibility_letter.f_responsibility_letter
                  where f_user_state = '正常'
                  ) files
where {condition}
order by
    f_userinfo_code