select *
from (
         select *,
                case when f_hand_month > 0 or f_webhand_day > 0 then '抄表异常' else '抄表正常' end f_state_hand
         from (
                  select u.f_userinfo_code,                                                                               --用户编号
                         u.f_user_name,                                                                                   --姓名
                         ua.f_address,                                                                                    --地址
                         u.f_user_state,                                                                                  --用户状态
                         uf.f_table_state,                                                                                --表状态
                         uf.f_meter_classify,                                                                             --气表类型
                         uf.f_user_type,                                                                                  --客户类型
                         uf.f_gasproperties,                                                                              --用户性质
                         gb.f_meter_brand,                                                                                --气表品牌
                         uf.f_meternumber,                                                                                --表号
                         mb.f_book_name,                                                                                  --抄表册名称
                         uf.f_meter_book_num,
                         uf.f_meter_book_sort,                                                                            --册内排序
                         u.f_open_date,                                                                                   --开户时间
                         uf.f_open_date                                                                  f_open_date1,
                         uf.f_orgid,
                         uf.f_depid,
                         uf.f_operatorid,
                         uf.f_orgname,
                         uf.f_depname,
                         uf.f_operator,
                         case
                             when uf.f_meter_classify = '机表' then h.f_hand_min_date
                             else wh.f_hand_min_date end                                                 f_hand_min_date, --期间初次上报日期
                         case
                             when uf.f_meter_classify = '机表' then h.f_hand_max_date
                             else wh.f_hand_max_date end                                                 f_hand_max_date, --期间最后上报日期
                         case when uf.f_meter_classify = '机表' then h.c else wh.c end                   f_number,        --期间上报次数
                         case
                             when uf.f_meter_classify = '机表' then h.f_oughtamount
                             else wh.f_oughtamount end                                                   f_oughtamount,   --期间用气量
                         case
                             when uf.f_meter_classify = '机表' then h.f_oughtfee
                             else wh.f_oughtfee end                                                      f_oughtfee,      --期间用气金额
                         case
                             when uf.f_meter_classify = '机表' then
                                 case
                                     when h.f_hand_max_date is not null
                                         then DATEDIFF(month, h.f_hand_max_date, '{endDate}')
                                     else DATEDIFF(month, '{startDate}', '{endDate}') end
                             else 0 end                                                                  f_hand_month,    --机表未抄期数
                         case
                             when uf.f_meter_classify = '机表' then 0
                             else
                                 case
                                     when wh.f_hand_max_date is not null
                                         then DATEDIFF(day, wh.f_hand_max_date, '{endDate}')
                                     else DATEDIFF(day, '{startDate}', '{endDate}') end
                             end                                                                         f_webhand_day    --物联未报天数
                  from t_userfiles uf
                           left join t_meter_book mb on uf.f_meter_book_num = mb.id
                           left join t_user_address ua on uf.f_userinfo_id = ua.f_userinfo_id
                           left join t_gasbrand gb on uf.f_gasbrand_id = gb.id
                           left join (
                      select f_userfiles_id,
                             MIN(f_hand_date)   f_hand_min_date,
                             MAX(f_hand_date)   f_hand_max_date,
                             count(*)           c,
                             sum(f_oughtamount) f_oughtamount,
                             sum(f_oughtfee)    f_oughtfee
                      from t_handplan
                      where f_hand_date >= '{startDate}'
                        and f_hand_date <= '{endDate}'
                        and f_hand_state = '有效'
                        and f_meter_state = '已抄表'
                      group by f_userfiles_id
                      ) h on uf.f_userfiles_id = h.f_userfiles_id
                           left join t_userinfo u on uf.f_userinfo_id = u.f_userinfo_id
                           left join (
                      select f_userfiles_id,
                             MIN(f_hand_date)   f_hand_min_date,
                             MAX(f_hand_date)   f_hand_max_date,
                             count(*)           c,
                             sum(f_oughtamount) f_oughtamount,
                             sum(f_oughtfee)    f_oughtfee
                      from t_web_handplan
                      where f_hand_date >= '{startDate}'
                        and f_hand_date <= '{endDate}'
                        and f_hand_state = '有效'
                        and f_meter_state = '已抄表'
                      group by f_userfiles_id
                      ) wh on uf.f_userfiles_id = wh.f_userfiles_id
                  where f_meter_classify != '气量卡表'
                    and f_meter_classify != '金额卡表'
                    and f_table_state = '正常'
                    and f_user_state = '正常'
                  ) h
         ) u
where f_state_hand = '抄表异常'
  and {condition}
order by f_userinfo_code desc