SELECT
    ROW_NUMBER() OVER (ORDER BY f_userinfo_code ASC) AS f_index,
    convert(numeric(19,2),isnull(avggas,0)) avggas,
    last_resment_gas,-- 上次应交用气量
    last_result_state, -- 上次抄表状态
    case when f_meter_state = '未抄表'
    then '自动估表'
    else f_result_state end f_result_state,
    f_bookid,--抄表册id
    f_book_name,
    f_book_state,
    f_meter_book_num,
    f_userfiles_id,
    f_userinfo_id,
    f_userinfo_code,
    f_user_id,
    f_user_name,
    f_user_level,
    f_ventilation_state,
    f_slice_area,
    f_address,
    f_small_area,
    f_user_phone,
    f_gasproperties,
    f_meternumber,
    f_inputtor,
    version,
    f_total_usegas_amount,
    f_total_fee,
    f_total_gas,
    f_last_tablebase,
    f_tablebase,
    f_actualtablebase,
    f_real_amount,
    f_real_fee,
    f_surplus_fee,
    f_hand_date,
    f_meter_state,
    f_type,f_unused_gas,
    f_user_type,
    f_meter_classify,
    f_remanent_money,
    f_correct_state,
    id,
    f_meter_base,
    f_initial_base,
    f_price_name,
    f_filiale,
    f_card_reason,
    f_special_user,
    f_last_hand_date,
    f_gasbrand_id,f_residential_area,f_unit,f_building,f_floor,f_room,f_orgid,f_depid,f_operatorid
FROM
    (
        SELECT
        avggas,--平均用气量
            last_resment_gas,
             last_result_state,
            f_bookid,--抄表册id
            f_book_name,
            f_book_state,
            f_meter_book_num,
            cast(f_userfiles_id as varchar) f_userfiles_id,
            cast(f_userinfo_id as varchar) f_userinfo_id,
            f_userinfo_code,
            cast(f_user_id as varchar) f_user_id,
            f_user_name,
            f_user_level,
            f_ventilation_state,
            f_slice_area,
            f_address,
            f_small_area,
            f_user_phone,
            f_gasproperties,
            newf_initial_base f_initial_base,
            meternumbers f_meternumber,
            f_inputtor,
            version,
            f_total_usegas_amount,
            f_total_fee,
            f_total_gas,
            f_last_tablebase,
            f_tablebase,
            case when (isnull(f_tablebase,0) - isnull(f_last_tablebase,0)) < 0 then 0
                 else (isnull(f_tablebase,0) - isnull(f_last_tablebase,0)) end f_actualtablebase,
            f_real_amount,
            isnull( f_real_fee, 0 ) f_real_fee,
            f_surplus_fee,
            f_hand_date,
            f_result_state,
            f_meter_state,
            f_type,f_unused_gas,
            f_user_type,
            f_meter_classify,
            isnull( f_remanent_money, 0 ) f_remanent_money,
            f_correct_state,
            id,
            f_meter_base,
            f_price_name,
            f_filiale,
            '' f_card_reason,
            f_special_user,
            CASE
                WHEN f_last_hand_date IS NULL THEN
                    f_last_hand_date_u ELSE f_last_hand_date
                END f_last_hand_date,
            f_gasbrand_id,f_residential_area,f_unit,f_building,f_floor,f_room,f_orgid,f_depid,f_operatorid
        FROM
            (
                SELECT
                    t.*,
                    CASE

                        WHEN f_meter_state != '未抄表' THEN
                            1 ELSE (
                        CASE

                            WHEN maxdate IS NULL THEN
                                0 ELSE (
                            CASE

                                WHEN maxdate >'{startDate}'  THEN
                                    0 ELSE ( CASE WHEN f_hand_date IS NULL THEN 0 ELSE ( CASE WHEN maxdate > f_hand_date THEN 0 ELSE 1 END ) END )
                                END
                            )
                            END
                        )
                        END f_state,
                    CASE

                        WHEN f_meter_state != '已抄表' THEN
                            1 ELSE ( CASE WHEN maxdate != f_hand_date THEN 1 ELSE 0 END )
                        END f_correct_state
                FROM
                    (
                        SELECT
                            u.*,
--首先判断卡表用户是否有最大日期的抄表记录
--第二判断用户当前归属期内有无抄表记录
--第三判断用户抄表周期前是否有抄表记录
--第四判断用户是否有换表记录
--第五判断用户最大换表时间是否大于最大抄表时间
                            CASE

                                WHEN c.meternumber IS NULL THEN
                                    u.f_meternumber ELSE c.meternumber
                                END meternumbers,
                            CASE

                                WHEN c.f_last_tablebase IS NULL THEN
                                    u.f_meter_base ELSE c.f_last_tablebase
                                END f_last_tablebase,
                            CASE
                                WHEN t.f_tablebase IS NULL
                                    AND c.f_tablebase IS NULL THEN
                                    0
                                WHEN c.f_tablebase IS NOT NULL THEN
                                    c.f_tablebase
                                WHEN t.f_tablebase IS NOT NULL
                                    AND c.f_tablebase IS NULL THEN
                                    0
                                END f_tablebase,
                            case when t.f_tablebase IS NULL
                                AND c.f_tablebase IS NULL THEN
                                     0
                                 else
                                     u.f_initial_base end
                                    newf_initial_base,
                            c.f_real_amount,
                            c.f_real_fee,
                            isnull( c.f_surplus_fee, 0 ) AS f_surplus_fee,
                            c.f_hand_date,
                            c.f_last_hand_date,
                            c.f_result_state,
                            isnull(c.f_unused_gas,0) f_unused_gas,
                            c.id,
                            CASE

                                WHEN c.id IS NULL THEN
                                    '未抄表' ELSE c.f_meter_state
                                END f_meter_state,
                            c.f_type,
                            maxdate,
                                -- 上次应交用气量
                                (select  { entity.findDialect() == $SqlServer$: $top 1$,$$} isnull(f_real_amount,0) from (select * from t_cardhand { entity.findDialect() == $SqlServer$: $$,$order by f_hand_date desc$})  tmp where tmp.f_user_id=u.f_user_id
                                                                                             and (tmp.f_hand_date<c.f_hand_date or c.f_hand_date is null) and f_meter_state='已抄表'
                                                                                            { entity.findDialect() == $SqlServer$: $order by tmp.f_hand_date desc$,$and rownum<=1$}
                                                                                                ) last_resment_gas,
                                -- 上次抄表状态
                                (select { entity.findDialect() == $SqlServer$: $top 1$,$$} isnull(f_result_state,'') from (select * from t_cardhand { entity.findDialect() == $SqlServer$: $$,$order by f_hand_date desc$})  tmp where tmp.f_user_id=u.f_user_id
                                                                                             and (tmp.f_hand_date<c.f_hand_date or c.f_hand_date is null) and f_meter_state='已抄表'
                                                                                             { entity.findDialect() == $SqlServer$: $order by tmp.f_hand_date desc$,$and rownum<=1$}
                                                                                               ) last_result_state,
                            av.avggas
                        FROM
                            (--查询所有卡表抄表用户
                                SELECT
                                    b.f_bookid,--抄表册id
                                    b.f_book_name,
                                    b.f_book_state,
                                    u.f_meter_book_num,
                                    u.f_userfiles_id,
                                    u1.f_special_user,
                                    u.f_card_id,
                                    u.f_userinfo_id,
                                    u1.f_ventilation_state,
                                    u.f_meternumber,
                                    u.f_use_meter_base,
                                    u.version,
                                    isnull(u.f_total_usegas_amount,0) f_total_usegas_amount,
                                    u.f_total_fee,
                                    u.f_total_gas,
                                    u.f_meter_base,
                                    u.f_user_type,
                                    u.f_gasproperties,
                                    ad.f_address,
                                    ad.f_small_area,
                                    u1.f_user_phone,
                                    u.f_initial_base,
                                    f_user_id,
                                    f_userinfo_code,
                                    u.f_meter_classify,
                                    u1.f_user_name,
                                    u1.f_user_level,
                                    s.f_price_name,
                                    u1.f_slice_area,
                                    u.f_inputtor,
                                    u.f_filiale,
                                    u.f_outlets,
                                    u.f_remanent_money,
                                    u.f_hand_date f_last_hand_date_u,
                                    u.f_gasbrand_id,f_residential_area,f_unit,f_building,f_floor,f_room,
                                    u.f_orgid,
                                    u.f_depid,
                                    u.f_operatorid
                                FROM
                                    (
                                        SELECT
                                            f_userfiles_id,
                                            f_card_id,
                                            f_userinfo_id,
                                            f_meternumber,
                                            f_hand_date,
                                            version,
                                            f_total_usegas_amount,
                                            f_total_fee,
                                            f_total_gas,
                                            f_meter_base,
                                            f_user_type,
                                            isnull(f_use_meter_base,0) f_use_meter_base,
                                            f_gasproperties,
                                            f_initial_base,
                                            f_user_id,
                                            f_meter_classify,
                                            f_inputtor,
                                            f_orgname f_filiale,
                                            f_gasbrand_id,
                                            '' f_outlets,   --青铜峡数据库无字段,未知是否有用
                                            f_remanent_money,
                                            f_meter_book_num,
                                            f_price_id,
                                            f_orgid,
                                            f_depid,
                                            f_operatorid
                                        FROM
                                            t_userfiles uf
                                        WHERE
                                                f_table_state = '正常'
                                          AND f_meter_classify LIKE '%卡表%'
                                    ) u
                                        JOIN ( SELECT f_userinfo_code,f_user_level, f_userinfo_id, f_special_user, '' f_address, f_user_name, '' f_slice_area, f_user_phone, f_ventilation_state FROM t_userinfo WHERE f_user_state = '正常' ) u1 ON u.f_userinfo_id= u1.f_userinfo_id
                                        LEFT JOIN ( SELECT f_userinfo_id, f_address,f_residential_area,f_unit,f_building,f_floor,f_room,f_small_area FROM t_user_address ) ad ON u.f_userinfo_id= ad.f_userinfo_id
                                        LEFT JOIN ( SELECT * FROM t_stairprice WHERE f_state = '有效' AND f_end_date > GETDATE() ) s ON u.f_price_id = s.f_price_id
                                        left join ( select id f_bookid,f_book_name,f_book_state from t_meter_book where f_book_state='有效')b ON u.f_meter_book_num=b.f_bookid
                            ) u
                                LEFT JOIN (--查询归属期内有抄表的用户抄表记录
                                SELECT
                                -- 上次应交用气量
                                (select  { entity.findDialect() == $SqlServer$: $top 1$,$$} isnull(f_real_amount,0) from (select * from t_cardhand { entity.findDialect() == $SqlServer$: $$,$order by f_hand_date desc$}) tmp where tmp.f_user_id=ch.f_user_id
                                                                                             and tmp.f_hand_date<ch.f_hand_date and f_meter_state='已抄表'
                                                                                             { entity.findDialect() == $SqlServer$: $order by tmp.f_hand_date desc$,$and rownum<=1$}) last_resment_gas,
                                -- 上次抄表状态
                                (select { entity.findDialect() == $SqlServer$: $top 1$,$$} isnull(f_result_state,'') from (select * from t_cardhand { entity.findDialect() == $SqlServer$: $$,$order by f_hand_date desc$}) tmp where tmp.f_user_id=ch.f_user_id
                                                                                             and tmp.f_hand_date<ch.f_hand_date and f_meter_state='已抄表'
                                                                                               { entity.findDialect() == $SqlServer$: $order by tmp.f_hand_date desc$,$and rownum<=1$}) last_result_state,
                                    ch.f_tablebase,
                                    ch.f_last_tablebase,
                                    ch.f_user_id,
                                    ch.f_userfiles_id,
                                    ch.f_last_hand_date,
                                    ch.f_real_amount,
                                    ch.f_real_fee,
                                    ch.f_hand_date,
                                    ch.f_result_state,
                                    ch.id,
                                    ch.f_unused_gas,
                                    --ch.f_orgid,
                                    --ch.f_depid,
                                    --ch.f_operatorid,
                                    ch.f_meter_state,
                                    s.f_surplus_fee,
                                    s.f_type,
                                    ch.f_meternumber meternumber
                                FROM
                                    t_cardhand ch
                                        LEFT JOIN ( SELECT f_handplan_id, f_type, SUM ( f_surplus_fee ) f_surplus_fee FROM t_surplus_detail WHERE f_surplus_fee > 0 AND f_type = '金额表补差' GROUP BY f_handplan_id, f_type ) s ON ch.id = s.f_handplan_id
                                WHERE
                                        ch.f_hand_date>= '{startDate} 00:00:00'
                                  AND ch.f_hand_date<= '{endDate} 23:59:59'
                                  AND f_meter_state != '冲正'
                                ) c ON u.f_userfiles_id= c.f_userfiles_id
                                LEFT JOIN (--查询卡表抄表的用户的查询日期前的最大抄表底数
                                SELECT DISTINCT MAX
                                                    ( c.f_tablebase ) f_tablebase,
                                                c.f_user_id
                                FROM
                                    ( SELECT f_user_id, MAX ( f_hand_date ) f_hand_date FROM t_cardhand WHERE f_hand_date < '{endDate} 23:59:59' AND f_meter_state != '冲正' GROUP BY f_user_id ) t
                                        LEFT JOIN t_cardhand c ON t.f_user_id= c.f_user_id
                                        AND t.f_hand_date= c.f_hand_date
                                WHERE
                                        f_meter_state != '冲正'
                                GROUP BY
                                    c.f_user_id
                                ) t ON u.f_user_id= t.f_user_id
                                LEFT JOIN ( --查询卡表用户最大抄表时间
                                SELECT f_user_id, MAX ( f_hand_date ) maxdate FROM t_cardhand WHERE f_meter_state != '冲正' GROUP BY f_user_id ) t1 ON u.f_user_id= t1.f_user_id
                                LEFT JOIN ( --查询换表用户的换表时间
                                SELECT f_user_id, MAX ( id ) f_maxdate FROM t_changetables WHERE f_state = '有效' GROUP BY f_user_id ) cm ON u.f_user_id= cm.f_user_id
                                LEFT JOIN ( SELECT f_user_id cms_userid,id, f_operate_date cms_date, f_initial_base_new FROM t_changetables WHERE f_state = '有效' ) cms ON cm.f_user_id = cms.cms_userid
                                AND cm.f_maxdate = cms.id
                                LEFT JOIN (
                                    select sum(f_real_amount)/count(*) avggas,f_user_id
                                    from t_cardhand h
                                    where f_meter_state='已抄表'
                                    group by f_user_id
                                )av on  av.f_user_id=u.f_user_id
                    ) t
            ) t UNION ALL--查询卡表冲正记录
        SELECT
        avggas,--平均用气量
         -- 上次应交用气量
            (select  { entity.findDialect() == $SqlServer$: $top 1$,$$} isnull(f_real_amount,0) from (select * from t_cardhand { entity.findDialect() == $SqlServer$: $$,$order by f_hand_date desc$}) tmp where tmp.f_user_id=c.f_user_id
                                                                         and tmp.f_hand_date<c.f_hand_date and f_meter_state='已抄表'
                                                                         { entity.findDialect() == $SqlServer$: $order by tmp.f_hand_date desc$,$and rownum<=1$}) last_resment_gas,
            -- 上次抄表状态
            (select  { entity.findDialect() == $SqlServer$: $top 1$,$$} isnull(f_result_state,'') from (select * from t_cardhand { entity.findDialect() == $SqlServer$: $$,$order by f_hand_date desc$}) tmp where tmp.f_user_id=c.f_user_id
                                                                           and tmp.f_hand_date<c.f_hand_date and f_meter_state='已抄表'
                                                                          { entity.findDialect() == $SqlServer$: $order by tmp.f_hand_date desc$,$and rownum<=1$}) last_result_state,
            b.f_bookid,--抄表册id
            b.f_book_name,
            b.f_book_state,
            uf.f_meter_book_num,
            cast(uf.f_userfiles_id as varchar) f_userfiles_id,
            cast(c.f_userinfo_id as varchar) f_userinfo_id,
            u.f_userinfo_code,
            cast(c.f_user_id as varchar) f_user_id,
            f_user_name,
            f_user_level,
            '' f_ventilation_state,
            '' f_slice_area,
            ad.f_address,
            ad.f_small_area,
            f_user_phone,
            f_gasproperties,
            f_initial_base,
            f_meternumber f_meternumber,
            f_inputtor,
            version,
            0 f_total_usegas_amount,
            0 f_total_fee,
            0 f_total_gas,
            f_last_tablebase,
            f_tablebase,
            case when (isnull(f_tablebase,0) - isnull(f_last_tablebase,0)) < 0 then 0
                 else (isnull(f_tablebase,0) - isnull(f_last_tablebase,0)) end f_actualtablebase,
            f_real_amount,
            isnull( f_real_fee, 0 ) f_real_fee,
            f_surplus_fee,
            f_hand_date,
            f_result_state,
            '冲正' f_meter_state,
            '' f_type,
            isnull(c.f_unused_gas,0) f_unused_gas,
            f_user_type,
            '' f_meter_classify,
            0 f_remanent_money,
            1 f_correct_state,
            c.id,
            0 f_meter_base,
            '' f_price_name,
            f_filiale,
            isnull( f_card_reason, '' ) f_card_reason,
            u.f_special_user,
            f_last_hand_date,
            uf.f_gasbrand_id,f_residential_area,f_unit,f_building,f_floor,f_room,c.f_orgid,c.f_depid,c.f_operatorid
        FROM
            ( SELECT * FROM t_cardhand WHERE f_hand_date >= '{startDate} 00:00:00' AND f_hand_date <= '{endDate} 23:59:59' AND f_meter_state = '冲正' ) c
                LEFT JOIN ( SELECT f_userinfo_code,f_user_level, f_userinfo_id, f_special_user, f_user_phone FROM t_userinfo ) u ON c.f_userinfo_id= u.f_userinfo_id
                LEFT JOIN ( SELECT f_userinfo_id, f_address,f_residential_area,f_unit,f_building,f_floor,f_room,f_small_area FROM t_user_address ) ad ON u.f_userinfo_id= ad.f_userinfo_id
                LEFT JOIN ( SELECT f_userinfo_id, f_gasbrand_id,f_userfiles_id,f_user_id,f_initial_base,f_meter_base,version,f_meter_book_num FROM t_userfiles ) uf ON c.f_user_id= uf.f_user_id
                left join ( select id f_bookid,f_book_name,f_book_state from t_meter_book where f_book_state='有效')b ON uf.f_meter_book_num=b.f_bookid
                LEFT JOIN (
                                    select sum(f_real_amount)/count(*) avggas,f_user_id
                                    from t_cardhand h
                                    where f_meter_state='已抄表'
                                    group by f_user_id
                                )av on  av.f_user_id=c.f_user_id
    ) s
WHERE
  {condition}
order by {orderitem}
