select f_orgname,
       CONVERT(VARCHAR(10), f_time_end, 120)      f_time_end,
       Convert(decimal(18, 2), sum(f_total_fee))  f_total_fee,
       Convert(decimal(18, 2), sum(f_collection)) f_collection
from (SELECT isnull((w.f_total_fee + 0.00) / (100 + 0.00), 0)                  f_total_fee,
             w.f_attach,
             w.id,
             w.f_order_state,
             w.f_order_type,
             w.f_trade_type,
             w.f_operator,
             CONVERT(VARCHAR(10), isnull(w.f_time_ends, w.f_create_time), 120) f_time_end,
             w.f_transaction_id,
             isnull(w.f_userinfo_code, s.f_userinfo_code)                      f_userinfo_code,
             isnull(w.f_userinfo_id, s.f_userinfo_id)                          f_userinfo_id,
             isnull(w.f_userfiles_id, s.f_userfiles_id)                        f_userfiles_id,
             isnull(w.f_meter_classify, s.f_meter_type)                        f_meter_type,
             isnull(w.f_user_name, s.f_user_name)                              f_user_name,
             w.f_orgid                                                         f_orgid,
             isnull(s.f_orgname, w.f_orgname)                                  f_orgname,
             s.f_type,
             s.f_serial_id,
             s.f_collection,
             s.f_operate_date,
             s.f_depname,
             s.f_depid,
             s.f_operatorid
      FROM (SELECT wx.id,
                   wx.f_trade_type,
                   wx.f_total_fee,
                   wx.f_transaction_id,
                   wx.f_time_end,
                   wx.f_attach,
                   wx.f_order_state,
                   wx.f_order_type,
                   wx.f_create_time,
                   wx.f_orgid,
                   wx.f_userfiles_id,
                   wx.f_operator,
                   wx.f_operate_date,
                   isnull(wx.f_orgname, uf.f_orgname)         f_orgname,
                   isnull(wx.f_depid, uf.f_depid)             f_depid,
                   wx.f_depname,
                   CAST(convert(varchar(100), SUBSTRING(f_time_end, 1, 4) + '-' + SUBSTRING(f_time_end, 5, 2) + '-' +
                                              SUBSTRING(f_time_end, 7, 2) + ' ' + SUBSTRING(f_time_end, 9, 2) + ':' +
                                              SUBSTRING(f_time_end, 11, 2) + ':' + SUBSTRING(f_time_end, 13, 2),
                                23) as varchar) f_time_ends,
                   uf.f_meter_classify,
                   uf.f_userinfo_id,
                   ui.f_userinfo_code,
                   ui.f_user_name
            FROM t_weixinreturnxml wx
                     LEFT JOIN t_userfiles uf ON wx.f_userfiles_id = uf.f_userfiles_id
                     LEFT JOIN t_userinfo ui ON uf.f_userinfo_id = ui.f_userinfo_id
                     LEFT JOIN t_organization org ON org.id = wx.f_orgid
            WHERE wx.f_order_state = '已支付'
              and wx.f_transaction_id is not null
              and wx.f_transaction_id <> '') w
               left join (SELECT s.f_serial_id,
                                 s.f_userinfo_id,
                                 s.f_userfiles_id,
                                 s.f_meter_type,
                                 s.f_user_name,
                                 s.f_orgid,
                                 s.f_orgname,
                                 s.f_depid,
                                 s.f_operatorid,
                                 s.f_operator,
                                 s.f_depname,
                                 s.f_type,
                                 s.f_collection,
                                 s.f_operate_date,
                                 ui.f_userinfo_code
                          FROM t_sellinggas s
                                   LEFT JOIN t_userinfo ui ON s.f_userinfo_id = ui.f_userinfo_id
                          where f_operate_date >= '{startDate} 00:00:00'
                            and f_operate_date <= '{endDate} 23:59:59'
                            and s.f_state = '有效'
                          union all
-- 		   其他收费
                          SELECT s.f_serial_id,
                                 s.f_userinfo_id,
                                 s.f_userfiles_id,
                                 '其他收费' f_meter_type,
                                 ui.f_user_name,
                                 s.f_orgid,
                                 s.f_orgname,
                                 s.f_depid,
                                 s.f_operatorid,
                                 s.f_operator,
                                 s.f_depname,
                                 '其他收费' f_type,
                                 s.f_collection,
                                 s.f_operate_date,
                                 ui.f_userinfo_code
                          FROM t_othercharge s
                                   LEFT JOIN t_userinfo ui ON s.f_userinfo_id = ui.f_userinfo_id
                          WHERE s.f_state = '有效'
                            and f_operate_date >= '{startDate} 00:00:00'
                            and f_operate_date <= '{endDate} 23:59:59') s on w.f_transaction_id = s.f_serial_id) tt
where {condition} and f_time_end >='{startDate}' and f_time_end <='{endDate}'
GROUP BY f_time_end, f_orgname
order by f_orgname, f_time_end desc
