SELECT
    *
FROM
    (
        SELECT
            ui.f_userinfo_id,
            ui.f_userinfo_code,
            ui.f_user_name,
            ui.f_user_phone,
            ui.f_user_nature,
            ui.f_last_check_result,
            ui.f_last_check_date,
            datediff(day,ui.f_last_check_date,getdate()) f_check_day,
            uf.f_user_type,
            uf.f_gasproperties,
            uf.f_table_state,
            uf.f_orgid,
            gb.f_meter_brand,
            ua.f_address,
            ua.f_slice_area f_zones,
            case when h.f_oughtfee is null  then '否'
                 else
                     case when h.f_oughtfee-ui.f_balance <0 then '否' else '是' end
                end f_pay_state,
            isnull(case when ui.f_balance>0 then
                case when h.f_oughtfee-ui.f_balance <0 then 0 else h.f_oughtfee-ui.f_balance end
            else h.f_oughtfee end,0) f_oughtfee,
            da.id,
            case when uf.f_table_state ='停用' then da.f_comments else '' end f_comments,
            case when uf.f_table_state ='停用' then da.f_operate_date else '' end f_operate_date,
            da.f_orgname,
            da.f_depname,
            da.f_depid,
            da.f_operator,
            da.f_operatorid
        FROM
         t_userfiles uf
        LEFT JOIN t_userinfo ui ON ui.f_userinfo_id = uf.f_userinfo_id
        LEFT JOIN t_user_address ua ON ui.f_userinfo_id = ua.f_userinfo_id
        LEFT JOIN t_gasbrand gb ON uf.f_gasbrand_id = gb.id
        LEFT JOIN (select f_userfiles_id,max(id) maxid from t_disable where f_state='有效' group by f_userfiles_id) d
            ON uf.f_userfiles_id = d.f_userfiles_id
        left join t_disable da on d.maxid = da.id
        left join (
                select f_userfiles_id,sum(f_oughtfee) f_oughtfee from t_handplan
                where f_meter_state='已抄表' and f_hand_state='有效' and f_whether_pay='否' and f_oughtfee>0
                group by f_userfiles_id
        ) h on uf.f_userfiles_id = h.f_userfiles_id
    ) da
WHERE
    { condition }
ORDER BY
    da.id DESC
