select
 *,
 (select top 1  f_valveState from t_meteread where id=u.f_meteread_maxid) f_valveState,
 (select top 1  f_jval from t_meteread where id=u.f_meteread_maxid) f_jval
from(
	select
		u.f_user_name,	    --用户姓名
		a.f_address,	    --用户地址
		u.f_user_state,	    --用户状态
		u.f_userinfo_code,  --用户统一编码
		u.f_userinfo_id,
		u.f_user_phone,	    --用户电话
		u.f_rent_phone,	    --备用电话
		u.f_idnumber,    --证件号码
		u.f_people_num,
		u.f_credentials,    --证件类型
		{entity.findDialect()==$SqlServer$: $isnull$,$NVL$}(u.f_balance,0) f_balance,        --账户余额
		uf.f_user_type,	    --用户类型
		uf.f_gasproperties,	--用气性质
		uf.f_position,      --安装位置
		uf.f_input_date, --建表日期
		uf.f_times,
		uf.f_iot_times,
		uf.f_meteread_maxid,
		uf.f_table_state,	--气表状态
		uf.f_balance_gas,     --剩余气量
		uf.f_balance_amount,  --剩余金额
		uf.f_meternumber,	  --表钢号
		uf.f_user_id,         --表编号
		uf.f_aroundmeter,     -- 左右表
		uf.f_userfiles_id,
		isnull(uf.f_network_valve,'0')f_network_valve,
		{entity.findDialect()==$SqlServer$: $isnull$,$NVL$}(uf.f_total_gas,0) f_total_gas,  --累计气量
		{entity.findDialect()==$SqlServer$: $isnull$,$NVL$}(uf.f_total_fee,0) f_total_fee,  --累计气量
		uf.f_open_date,	      --开户日期
		uf.f_initial_base,	  --初始底数
		uf.f_meter_base,	  --系统底数/最后上报底
		uf.f_meter_book_num,
		uf.f_meter_book_sort,
		mb.f_book_name,
		mb.f_book_code,

		uf.f_meteread_date,   -- 最后上报时间(IOT)
		uf.f_hand_date, -- 最后抄表时间(IOT)
		uf.f_meteread_number, -- 累计上报次数(IOT)
		uf.f_total_usegas_amount, -- 累计用气金额(IOT)
		--case when mr1.f_valveState = 0 then '关阀' else '开阀' end f_valveState,  -- 阀门状态
		gb.f_meter_brand,	  --气表品牌
		gb.f_meter_type,     --气表类型
        gb.f_alias,           --别名
        gb.f_collection_type, --扣费类型
        gb.f_calculation,    --结算方式
		gm.f_meter_style,	  --气表型号
		sp.f_price_type,	  --气价类型
		sp.f_price_name,	  --气价名称
        uf.f_off_valve_reason, --开关阀备注
		detailprice.f_detailprice,  --价格明细
        ({entity.findDialect()==$SqlServer$: $isnull$,$NVL$}(uf.f_total_fee,0)) total_fee,
        f_total_gas_all,
        f_total_fee_all
	from t_userfiles uf
        left join (
        select f_userinfo_id,sum(f_total_gas - isnull(f_newtable_fillgas,0)) f_total_gas_all,sum(f_total_fee) f_total_fee_all
        from t_userfiles group by f_userinfo_id
        ) ui on ui.f_userinfo_id = uf.f_userinfo_id
	    left join ( select f_remanent_money,f_userfiles_id filesid from t_changetables where f_state='有效')ct on uf.f_userfiles_id=ct.filesid
		left join t_userinfo u on uf.f_userinfo_id=u.f_userinfo_id
		left join t_gasbrand gb on uf.f_gasbrand_id = gb.id
		left join t_gasmodel gm on uf.f_gasmodel_id = gm.id
		LEFT JOIN t_user_address a ON (a.f_userinfo_id = u.f_userinfo_id)
		left join (select * from t_stairprice where f_state='有效' and getdate()>=f_perform_date and getdate()<=f_end_date)	sp on uf.f_price_id=sp.f_price_id
    LEFT JOIN (
    select
      f_stairprice_id,
      {entity.findDialect()==$SqlServer$: $(select cast(f_price as varchar) + '|' from t_detailprice where f_stairprice_id=d.f_stairprice_id for xml path(''))$,
      $(select to_char(replace(WMSYS.WM_CONCAT(cast(f_price as varchar2(200))), ',', '|')) from t_detailprice where f_stairprice_id=d.f_stairprice_id )$} as
       f_detailprice
    from t_detailprice d group by f_stairprice_id
  ) detailprice ON sp.id = detailprice.f_stairprice_id
  left join t_meter_book mb on uf.f_meter_book_num = mb.id
) u
where {condition} and f_table_state != '换表' and f_table_state != '无效'
