SELECT  *
FROM (
    SELECT
        (CASE
            WHEN mid_t.f_whether_reciliat = '否' THEN '未对账'
            WHEN bill_t.f_serial_id IS NULL AND mid_t.f_sell_id IS NOT NULL THEN '支付宝单方面账单'
            WHEN bill_t.f_serial_id IS NOT NULL AND mid_t.f_sell_id IS NULL THEN '燃气方单方面账单'
            else '对账成功'
        END) msg,
        {entity.findDialect()==$SqlServer$: $isnull$,$NVL$}(( mid_t.f_total_charge + 0.00 ) / ( 100 + 0.00 ),0) f_total_charge,
        mid_t.f_trade_date f_datatime,
        mid_t.f_sell_id,
        mid_t.id,
        {entity.findDialect()==$SqlServer$: $isnull$,$NVL$}(mid_t.f_userinfo_code,bill_t.f_userinfo_code) f_userinfo_code,
        bill_t.f_payment,
        bill_t.f_serial_id,
        {entity.findDialect()==$SqlServer$: $isnull$,$NVL$}(bill_t.f_collection, 0) f_collection,
        bill_t.f_operate_date,
        {entity.findDialect()==$SqlServer$: $isnull$,$NVL$}(bill_t.f_orgid, mid_t.f_filialeid) f_orgid,
        bill_t.f_orgname,
        bill_t.f_depid,
        bill_t.f_depname,
        bill_t.f_operatorid,
        bill_t.f_operator,
        bill_t.f_user_name
    FROM (
        SELECT
            id,
            f_trade_date,
            f_total_charge,
            f_sell_id,
            f_userinfo_code,
            f_whether_reciliat,
            f_filialeid
        FROM t_bank_payment
        WHERE f_whether_reciliat IS NOT NULL
        AND f_order_state IS NULL
        AND f_trade_date >= '{startDate} 00:00:00'
        AND f_trade_date <= '{endDate} 23:59:59'
    ) mid_t
    FULL OUTER JOIN (
        SELECT
            sell.f_payment,
            sell.f_operate_date,
            sell.f_collection,
            sell.id f_serial_id,
            sell.f_orgid,
            sell.f_orgname,
            sell.f_depid,
            sell.f_depname,
            sell.f_operatorid,
            sell.f_operator,
            sell.f_userinfo_id,
            userinfo.f_userinfo_code,
            sell.f_user_name
        FROM t_sellinggas sell
        RIGHT JOIN t_userinfo userinfo ON sell.f_userinfo_id = userinfo.f_userinfo_id
        WHERE sell.f_state = '有效'
        AND sell.f_payment LIKE '%支付宝%'
        AND sell.f_operate_date >= '{startDate} 00:00:00'
        AND sell.f_operate_date <= '{endDate} 23:59:59'
    ) bill_t ON mid_t.f_sell_id = bill_t.f_serial_id
) tt
where {condition}
ORDER BY f_datatime DESC
