SELECT * from (
SELECT
    ads.f_buy_date,
    ads.f_fee_type,
    ads.f_expiration_date,
    ads.f_ins_start_date,
    ads.f_money,
    ads.id,
    ads.f_payment,
    ads.f_operate_date,
    ads.f_last_insexpiration_date,
    ads.f_shengxiao_date,
    ads.f_ok_number,
    ads.f_insurance_type,
    ads.f_salecount,
    ads.f_comments,
    ads.f_orgid,
    ads.f_depid,
    ads.f_operatorid,
    ads.f_ins_number,
    ads.f_operator,
    ui.f_user_state,
    isnull(ads.f_user_name,ui.f_user_name) f_user_name,
    isnull(ads.f_user_phone,ui.f_user_phone) f_user_phone,
    isnull(ads.f_idnumber,ui.f_idnumber) f_idnumber,
    ui.f_userinfo_code,
    ui.f_userinfo_id,
    ua.f_address,
    DATEDIFF(day,GETDATE(),ads.f_expiration_date) AS f_days, --到期剩余天数
    case when ads.f_state = '无效' then '无效' else
        (case when GETDATE() < f_shengxiao_date then  '未开始'
              when GETDATE() > f_expiration_date then '失效'
              else '有效' end ) end f_state
FROM
t_userinfo ui
LEFT JOIN t_userfees ads on ui.f_userinfo_id = ads.f_userinfo_id
LEFT JOIN t_user_address ua on ui.f_userinfo_id = ua.f_userinfo_id
)  f WHERE {condition} and  f_user_state!='销户'
ORDER BY f_userinfo_id DESC
