select * from
(
   select   uf.version,
              uf.f_user_id,
              uf.f_userfiles_id,
              uf.f_userinfo_id,
              f_meter_base,
              mb.f_inputtor,
              uf.f_meternumber,
              uf.f_fire_state,
              uf.f_remanent_gas,
              uf.f_initial_base,
              uf.f_totalsplit_type,
              uf.f_share_ratio,
              uf.f_price_id,
              uf.f_user_type,
              uf.f_gasproperties,
              uf.f_meter_book_num,
              uf.f_meter_book_sort,
              mb.f_book_name,
              u.f_userinfo_code,
              u.version userinfo_version,
              u.f_user_name,
              u.f_user_phone,
              u.f_user_state,
              u.f_filialeid,
              u.f_orgid,
              u.f_depid,
              u.f_user_level,
              u.f_operatorid,
              uf.f_hand_date f_last_hand_date,
              u.f_balance,
              uf.f_usetype,
              address.f_address,
              address.f_slice_area f_zones,
              address.f_residential_area,
              address.f_building,
              address.f_unit,
              address.f_floor,
              address.f_room,

              adbox.f_adjustable_id,
              adbox.f_adjustable_name,

              t_gasbrand.f_meter_brand,
              t_gasbrand.f_meter_type,
              t_gasmodel.f_meter_style,
              uf.f_garbage_fee,
              address.f_small_area,
              h1.num
   from t_userfiles uf
        left join t_meter_book mb on uf.f_meter_book_num=mb.id
        left join t_user_address address on uf.f_useraddress_id = address.id
        left join t_area area on address.f_residential_area_id = area.id
        left join t_adjustablebox adbox on adbox.id = uf.f_adjustable_id
        left join t_userinfo u on uf.f_userinfo_id=u.f_userinfo_id
        left join t_gasbrand ON t_gasbrand.id = uf.f_gasbrand_id
        left join t_gasmodel ON t_gasmodel.id = uf.f_gasmodel_id
        left join (
            select max(id) handid,f_userfiles_id fileid
            from t_handplan
            where f_hand_state ='有效' and f_hand_date>'{startDate} 00:00:00' group by f_userfiles_id
        ) h on uf.f_userfiles_id=h.fileid
        left join (
          select f_userfiles_id fileids,count(*) num from t_handplan where  f_hand_state ='有效'
           and (f_meter_state='待审核' or f_meter_state='未抄表')
          group by f_userfiles_id
        ) h1 on uf.f_userfiles_id=h1.fileids
   where
        h.handid is null
        and uf.f_meter_classify='机表'
        and (u.f_user_state = '正常' or  u.f_user_state = '封堵')
        and (uf.f_table_state='正常' or uf.f_table_state='停用' or uf.f_table_state='封堵')
) u
where   {condition}
order by {orderitem}
