--单用户失联明细查询
--	2019-03-01指系统上线时间
select
	*
from (
	select
		f_meternumber,
		f_upload_type,	--上报类型
		m.f_hand_date,	--上报日期
		convert(varchar(100),m.f_last_hand_date,20) f_last_hand_date,	--上次上报日期
		cast(m.f_last_tablebase as varchar) f_last_tablebase, --上次抄表底数
		cast(m.f_tablebase as varchar) f_tablebase,	--本次抄表底数
        { entity.findDialect() == $SqlServer$:
            $
                cast(f_tablebase-f_last_tablebase as varchar)
            $,
	        $
	            to_char(f_tablebase-f_last_tablebase)
            $} f_gas,

		convert(varchar(100),f_insert_date,20) f_insert_date,	--系统接收时间
		f_signal,  -- 噪音强度
		f_snr,   -- 信噪比
		f_batteryLevel, -- 电压
		f_networkShutValve, --阀门强制状态
		f_valveState,  --阀门状态
		f_wmprepaytype,  --计量类型

    f_moneyState,  -- 金额状态
    f_LowLithiumBattery, --电压状态
    f_magneticInterference, --磁干扰异常
    f_meterDebitAmt, --表内累计充值金额
    f_compensateState, --补偿状态
    f_jval,
    case  br.f_calculation   when '系统结算'
    then h.f_curbalance  else
    cast(case when m.f_meterBalanceAmt='' then '0'
    else m.f_meterBalanceAmt end as float) end f_meterBalanceAmt -- 表内剩余金额
	from t_meteread m
    left join  (select  f_gasbrand_id,f_userfiles_id uf_userfiles_id from t_userfiles) uf on uf.uf_userfiles_id=m.f_userfiles_id
    left  join (select  f_curbalance,f_meteread_id  from t_web_handplan m where {condition} ) h on h.f_meteread_id  = m.id
    left  join  t_gasbrand br ON uf.f_gasbrand_id= br.id
	where 1=1 and {condition}
) s
order by f_hand_date desc,f_insert_date desc
