SELECT * FROM (
	SELECT
		f_userinfo_code,--客户编号
		f_user_name,--用户姓名
		f_meter_classify,
		COUNT(*) c,--欠费次数
	  CASE
			WHEN CONVERT ( VARCHAR ( 7 ), MIN ( f_hand_date ), 23 ) = CONVERT ( VARCHAR ( 7 ), MAX ( f_hand_date ), 23 ) THEN
			CONVERT ( VARCHAR ( 7 ), MIN ( f_hand_date ), 23 ) ELSE CONVERT ( VARCHAR ( 7 ), MIN ( f_hand_date ), 23 ) + '至' + CONVERT ( VARCHAR ( 7 ), MAX ( f_hand_date ), 23 )
		END f_hand_date,--欠费区间
	  ( SELECT f_last_tablebase FROM t_handplan WHERE id = MIN ( h.handplan_id ) ) f_last_tablebase,
		( SELECT f_tablebase FROM t_handplan WHERE id = MAX ( h.handplan_id ) ) f_tablebase,
    SUM ( isnull(f_oughtamount, 0) ) f_oughtamount,--用气量
    SUM ( isnull(f_oughtfee_all, 0) ) f_oughtfee,--用气金额
    SUM ( isnull(f_debt_money, 0 ) ) f_debt_money,--已交金额
	  SUM ( isnull(f_oughtfee, 0) ) f_oughtfee_new,--应交气费
	  SUM ( isnull(f_oughtfee, 0) ) f_oughtfee_all,--合计欠费
    SUM ( 0 ) overdue,
		MAX ( h.handplan_id ) max_handplan_id,
		MIN ( h.handplan_id ) min_handplan_id,
        price,
		f_userinfo_id,--户编号
		f_address,--地址
		f_user_phone--用户电话
FROM (
    SELECT
      f_userinfo_code,
      f_userinfo_id,
      f_user_name,
      f_meter_classify,
      CONCAT(
              CASE WHEN f_stair_gas1 > 0   THEN CAST(cast(f_stair1price as float) AS varchar)+';'+CAST(cast(f_stair_gas1 as int) AS varchar)   ELSE '' END,
              CASE WHEN f_stair_gas2 > 0   THEN CONCAT('| ', CAST(cast(f_stair2price as float) AS varchar)+';'+CAST(cast(f_stair_gas2 as int) AS varchar))  ELSE '' END,
              CASE WHEN f_stair_gas3 > 0   THEN CONCAT('| ', CAST(cast(f_stair3price as float) AS varchar)+';'+CAST(cast(f_stair_gas3 as int) AS varchar))  ELSE '' END
      ) AS price,
      f_hand_date,--抄表日期
      handplan_id,--抄表记录id
      f_last_tablebase,--上期指数
      f_tablebase,--本期指数
      f_address,
      f_user_phone,--用户电话
      f_oughtamount f_oughtamount,--应交气量  convert(decimal(18,2),f_oughtamount)  ROUND(f_oughtamount,2)
      f_oughtfee f_oughtfee_all,--应交金额
      ROUND(f_oughtfee - f_debt_money, 2) f_oughtfee,--实际应交金额 convert(decimal(18,2),f_oughtfee-f_debt_money) ROUND(f_oughtfee-f_debt_money,2)
      f_debt_money--已交气费 convert(decimal(18,2),f_debt_money) ROUND(f_debt_money,2)
    FROM (
      SELECT
        h.f_userinfo_code,
        h.f_userinfo_id,
        h.f_user_name,
        h.f_meter_classify,
        h.f_hand_date,
        h.f_stair_price1 f_stair1price,
        h.f_stair_price2 f_stair2price,
        h.f_stair_price3 f_stair3price,
        h.f_stair_gas1,
		h.f_stair_gas2,
		h.f_stair_gas3,
        h.id AS handplan_id,
        h.f_last_tablebase,
        h.f_tablebase,
        h.f_oughtamount,
        h.f_oughtfee,
        isnull(sh.f_debt_money, 0 ) f_debt_money,
        h.f_address,
        u.f_user_phone, --用户电话
        uf.f_civill_id
      FROM
        t_handplan h
        LEFT JOIN (
          SELECT f_hand_id,SUM (f_debt_money) f_debt_money FROM t_sellinghand d WHERE f_state = '有效' GROUP BY f_hand_id
        ) sh ON h.id = sh.f_hand_id
        LEFT JOIN t_userinfo u ON h.f_userinfo_id = u.f_userinfo_id
        LEFT JOIN t_userfiles uf ON h.f_userfiles_id = uf.f_userfiles_id
      WHERE
        f_whether_pay = '否'
        AND f_hand_state = '有效'
        AND h.f_meter_state = '已抄表'
        AND f_oughtfee > 0
    ) p
    WHERE
    { condition }
) h
GROUP BY
	f_userinfo_code,
	f_userinfo_id,
	f_user_name,
	f_address,
	price,
	f_user_phone,
	f_meter_classify
) s
ORDER BY f_userinfo_code